/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.safelayer.trustedx.client.axis.SendSoapHttp;
import com.safelayer.trustedx.client.axis.TxAxisClientException;
import com.safelayer.trustedx.jsse.TxNoValidateTrustManagerFactory;
import com.safelayer.trustedx.jsse.TxX509TrustManagerFactory;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import javax.net.ssl.TrustManagerFactory;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.httpclient.ChunkedInputStream;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.httpclient.StatusLine;

public class SendSoapHttpStream
extends SendSoapHttp {
    protected static final int HTTP_SC_INTERNAL_SERVER_ERROR = 500;
    protected static final int HTTP_SC_OK = 200;
    protected boolean allowCriticalExtensions;
    protected boolean useNoValidation;

    public OutputStream initChunkedTransfer(Socket socket, Hashtable hashtable, Hashtable hashtable2, String string) throws Exception {
        hashtable.put(HTTPConstants.HEADER_TRANSFER_ENCODING, HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED);
        hashtable.put("Host", this.host + ":" + Integer.toString(this.port));
        StringBuffer stringBuffer = this.generateHttpHeaderRequest(hashtable, hashtable2, null, "HTTP/1.1", string);
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(stringBuffer.toString().getBytes());
        ChunkedOutputStream chunkedOutputStream = new ChunkedOutputStream(outputStream, 16384);
        return chunkedOutputStream;
    }

    public OutputStream initTransfer(Socket socket, Hashtable hashtable, Hashtable hashtable2, int n, String string) throws Exception {
        StringBuffer stringBuffer = this.generateHttpHeaderRequest(hashtable, hashtable2, Integer.toString(n), "HTTP/1.0", string);
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        ((OutputStream)dataOutputStream).write(stringBuffer.toString().getBytes());
        return dataOutputStream;
    }

    public OutputStream initTransfer(Socket socket, Hashtable hashtable, Hashtable hashtable2, String string) throws Exception {
        StringBuffer stringBuffer = this.generateHttpHeaderRequest(hashtable, hashtable2, null, "HTTP/1.1", string);
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(stringBuffer.toString().getBytes());
        return outputStream;
    }

    public static int initProcessResponse(Socket socket) throws Exception {
        InputStream inputStream = socket.getInputStream();
        String string = HttpParser.readLine((InputStream)inputStream, (String)"iso-8859-1");
        if (string != null) {
            StatusLine statusLine = new StatusLine(string);
            int n = statusLine.getStatusCode();
            return n;
        }
        throw new TxAxisClientException("HttpConnectionError");
    }

    public static InputStream getTransferInputStream(Socket socket, Hashtable hashtable) throws Exception {
        HeaderElement[] headerElementArray;
        int n;
        InputStream inputStream = socket.getInputStream();
        Header[] headerArray = HttpParser.parseHeaders((InputStream)inputStream, (String)"iso-8859-1");
        Header header = null;
        for (int i = 0; i < headerArray.length; ++i) {
            hashtable.put(headerArray[i].getName(), headerArray[i].getValue());
            if (!headerArray[i].getName().equals(HTTPConstants.HEADER_TRANSFER_ENCODING)) continue;
            header = headerArray[i];
        }
        InputStream inputStream2 = inputStream;
        if (header != null && (n = (headerElementArray = header.getElements()).length) > 0 && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equalsIgnoreCase(headerElementArray[n - 1].getName())) {
            inputStream2 = new ChunkedInputStream(inputStream);
        }
        return inputStream2;
    }

    public static boolean isSuccesfulStatus(int n) {
        boolean bl = n == 200;
        return bl;
    }

    public static boolean isInternalErrorStatus(int n) {
        return n == 500;
    }

    public void setAllowCriticalExtensions(boolean bl) {
        this.allowCriticalExtensions = bl;
    }

    public void setUseNoValidation(boolean bl) {
        this.useNoValidation = bl;
    }

    protected void initSslContext() throws Exception {
        if (this.useNoValidation) {
            super.initSslContext((TrustManagerFactory)new TxNoValidateTrustManagerFactory(), null);
        } else if (this.allowCriticalExtensions) {
            super.initSslContext((TrustManagerFactory)new TxX509TrustManagerFactory(), null);
        } else {
            super.initSslContext();
        }
    }
}

