/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.safelayer.trustedx.client.axis.TrustedXSslSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import sun.misc.BASE64Encoder;

public class SendSoapHttp {
    protected static final String HEADER_CONTENT_LENGHT = "Content-Length";
    protected static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected static final String HEADER_AUTHORIZATION = "Authorization";
    protected static final String HEADER_PROXY_AUTHORIZATION = "Proxy-Authorization";
    protected static final String HEADER_CONNECTION = "Connection";
    protected boolean useKeystore;
    protected boolean useTrustStore;
    protected boolean proxy;
    protected boolean useNoCheckNames;
    protected int timeout = 0;
    protected int port;
    protected String keyType;
    protected String keyPath;
    protected String keyPwd;
    protected String trustPath;
    protected String trustPwd;
    protected String proxyHost;
    protected String proxyPort;
    protected String proxyUserInfo;
    protected String urlStr;
    protected String pathStr;
    protected String host;
    protected String userInfo;
    protected String validationAlg;
    protected Hashtable queryParams;
    protected SSLContext sslContext;
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };

    protected void configureSSL() {
        if (this.useTrustStore) {
            System.setProperty("javax.net.ssl.trustStore", this.trustPath);
            System.setProperty("javax.net.ssl.trustStorePassword", this.trustPwd);
            System.setProperty("javax.net.debug", "all");
        }
    }

    protected void configureProxy() {
        if (this.proxy) {
            String[] stringArray;
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", this.proxyPort);
            if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0) {
                stringArray = this.proxyUserInfo.split(":");
                System.setProperty("http.proxyUser", stringArray[0]);
                System.setProperty("http.proxyPassword", stringArray[1]);
            }
            if (this.useTrustStore) {
                System.setProperty("https.proxyHost", this.proxyHost);
                System.setProperty("https.proxyPort", this.proxyPort);
                if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0) {
                    stringArray = this.proxyUserInfo.split(":");
                    System.setProperty("https.proxyUser", stringArray[0]);
                    System.setProperty("https.proxyPassword", stringArray[1]);
                }
            }
        }
    }

    public byte[] postJDK(byte[] byArray) throws Exception {
        int n;
        HttpURLConnection httpURLConnection;
        Object object;
        Object object2;
        this.configureProxy();
        this.configureSSL();
        URL uRL = new URL(this.urlStr);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty(HEADER_CONTENT_LENGHT, String.valueOf(byArray.length));
        uRLConnection.setRequestProperty(HEADER_CONTENT_TYPE, "text/xml; charset=utf-8");
        uRLConnection.setRequestProperty(HEADER_CONNECTION, "Keep-Alive");
        if (this.urlStr.startsWith("https")) {
            object2 = new TrustedXSslSocketFactory();
            object = (HttpsURLConnection)uRLConnection;
            if (this.useNoCheckNames) {
                ((HttpsURLConnection)object).setHostnameVerifier(DO_NOT_VERIFY);
            }
            ((HttpsURLConnection)object).setSSLSocketFactory((SSLSocketFactory)object2);
            httpURLConnection = object;
        } else {
            httpURLConnection = (HttpURLConnection)uRLConnection;
        }
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        object2 = httpURLConnection.getOutputStream();
        ((OutputStream)object2).write(byArray);
        ((OutputStream)object2).close();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = httpURLConnection.getResponseCode();
        object = n2 < 300 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
        byte[] byArray2 = new byte[16384];
        while ((n = ((InputStream)object).read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        httpURLConnection.disconnect();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (byArray3 != null) {
            return byArray3;
        }
        throw new Exception("Empty response");
    }

    public void forceInit() throws Exception {
        this.sslContext = null;
        this.host = null;
        this.init();
    }

    public void init() throws Exception {
        this.initSslContext();
        if (this.host == null) {
            this.parseUrl();
        }
    }

    protected void initSslContext(TrustManagerFactory trustManagerFactory, KeyManagerFactory keyManagerFactory) throws Exception {
        TrustManagerFactory trustManagerFactory2 = trustManagerFactory;
        KeyManagerFactory keyManagerFactory2 = keyManagerFactory;
        if (this.sslContext == null) {
            Object object;
            if (this.useTrustStore) {
                if (trustManagerFactory2 == null) {
                    object = TrustManagerFactory.getDefaultAlgorithm();
                    if (this.validationAlg != null && this.validationAlg.length() > 0) {
                        object = this.validationAlg;
                    }
                    trustManagerFactory2 = TrustManagerFactory.getInstance((String)object);
                }
                object = KeyStore.getInstance(KeyStore.getDefaultType());
                object.load(new FileInputStream(this.trustPath), this.trustPwd.toCharArray());
                trustManagerFactory2.init((KeyStore)object);
            }
            if (this.useKeystore) {
                if (keyManagerFactory2 == null) {
                    keyManagerFactory2 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
                object = this.keyType != null ? KeyStore.getInstance(this.keyType) : KeyStore.getInstance(KeyStore.getDefaultType());
                object.load(new FileInputStream(this.keyPath), this.keyPwd.toCharArray());
                keyManagerFactory2.init((KeyStore)object, this.keyPwd.toCharArray());
            }
            if (trustManagerFactory2 != null || keyManagerFactory2 != null) {
                this.sslContext = SSLContext.getInstance("TLS");
                object = trustManagerFactory2 != null ? trustManagerFactory2.getTrustManagers() : null;
                this.sslContext.init(keyManagerFactory2 != null ? keyManagerFactory2.getKeyManagers() : null, (TrustManager[])object, null);
            }
        }
    }

    protected void initSslContext() throws Exception {
        this.initSslContext(null, null);
    }

    public Socket getSocket() throws Exception {
        Socket socket;
        if (this.urlStr.startsWith("https")) {
            TrustedXSslSocketFactory trustedXSslSocketFactory = this.sslContext != null ? new TrustedXSslSocketFactory(this.sslContext.getSocketFactory()) : new TrustedXSslSocketFactory();
            if (this.proxy) {
                Socket socket2 = new Socket(this.proxyHost, Integer.parseInt(this.proxyPort));
                this.doTunnelHandshake(socket2, this.host, this.port);
                socket = (SSLSocket)((SSLSocketFactory)((Object)trustedXSslSocketFactory)).createSocket(socket2, this.host, this.port, false);
            } else {
                socket = (SSLSocket)((SocketFactory)((Object)trustedXSslSocketFactory)).createSocket(this.host, this.port);
            }
        } else {
            socket = this.proxy ? new Socket(this.proxyHost, Integer.parseInt(this.proxyPort)) : new Socket(this.host, this.port);
        }
        if (this.timeout != 0) {
            socket.setSoTimeout(this.timeout);
        }
        return socket;
    }

    protected void parseUrl() throws Exception {
        URL uRL = new URL(this.urlStr);
        StringBuffer stringBuffer = new StringBuffer();
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        String string = uRL.getProtocol();
        stringBuffer.append(string);
        stringBuffer.append("://");
        stringBuffer.append(this.host);
        if (this.port == -1) {
            if (string.equals("http")) {
                this.port = 80;
            } else if (string.equals("https")) {
                this.port = 443;
            }
        }
        stringBuffer.append(":");
        stringBuffer.append(this.port);
        this.pathStr = uRL.getPath();
        stringBuffer.append(this.pathStr);
        String string2 = uRL.getUserInfo();
        String string3 = this.userInfo = this.userInfo == null ? string2 : this.userInfo;
        if (this.pathStr.length() == 0) {
            this.pathStr = "/";
        } else {
            String string4 = uRL.getQuery();
            if (string4 != null) {
                this.queryParams = new Hashtable();
                StringTokenizer stringTokenizer = new StringTokenizer(string4, "&");
                while (stringTokenizer.hasMoreTokens()) {
                    String string5 = stringTokenizer.nextToken();
                    String[] stringArray = string5.split("=");
                    if (stringArray != null && stringArray.length == 2) {
                        this.queryParams.put(URLEncoder.encode(stringArray[0], "UTF-8"), URLEncoder.encode(stringArray[1], "UTF-8"));
                        continue;
                    }
                    stringBuffer.append(string5);
                }
            }
        }
        this.urlStr = stringBuffer.toString();
    }

    protected void doTunnelHandshake(Socket socket, String string, int n) throws Exception {
        String string2;
        OutputStream outputStream = socket.getOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "US-ASCII");
        outputStreamWriter.write("CONNECT ");
        outputStreamWriter.write(string);
        outputStreamWriter.write(":");
        outputStreamWriter.write(Integer.toString(n));
        outputStreamWriter.write(" HTTP/1.0\r\n");
        outputStreamWriter.write("User-Agent: JavaHTTPClient\r\n");
        if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0 && this.proxy) {
            outputStreamWriter.write("Proxy-Authorization: Basic " + this.internalBase64Encode(this.proxyUserInfo) + "\r\n");
        }
        outputStreamWriter.write("\r\n");
        outputStreamWriter.flush();
        byte[] byArray = new byte[200];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        while (n3 < 2) {
            int n4 = inputStream.read();
            if (n4 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n4 == 10) {
                bl = true;
                ++n3;
                continue;
            }
            if (n4 == 13) continue;
            n3 = 0;
            if (bl || n2 >= byArray.length) continue;
            byArray[n2++] = (byte)n4;
        }
        try {
            string2 = new String(byArray, 0, n2, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray, 0, n2);
        }
        if (string2.toLowerCase().indexOf("200 connection established") == -1) {
            throw new IOException("Unable to tunnel through proxy.  Proxy returns \"" + string2 + "\"");
        }
    }

    private String internalBase64Encode(String string) throws Exception {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        String string2 = bASE64Encoder.encode(string.getBytes("US-ASCII"));
        return string2;
    }

    protected void appendHeader(String string, String string2, String string3, StringBuffer stringBuffer) {
        if (string.compareToIgnoreCase(HEADER_CONTENT_LENGHT) == 0) {
            if (string3 == null) {
                stringBuffer.append(string + ": " + string2 + "\r\n");
            }
        } else if (string.compareToIgnoreCase(HEADER_AUTHORIZATION) == 0) {
            if (this.userInfo == null || this.userInfo.length() == 0) {
                stringBuffer.append(string + ": " + string2 + "\r\n");
            }
        } else if (string.compareToIgnoreCase(HEADER_PROXY_AUTHORIZATION) == 0) {
            if (this.proxyUserInfo == null || this.proxyUserInfo.length() == 0) {
                stringBuffer.append(string + ": " + string2 + "\r\n");
            }
        } else {
            stringBuffer.append(string + ": " + string2 + "\r\n");
        }
    }

    protected StringBuffer generateHttpHeaderRequest(Hashtable hashtable, Hashtable hashtable2, String string, String string2, String string3) throws Exception {
        Enumeration enumeration;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = this.proxy ? new StringBuffer(this.urlStr) : new StringBuffer(this.pathStr);
        if (this.queryParams != null) {
            if (hashtable2 == null) {
                hashtable2 = new Hashtable();
            }
            hashtable2.putAll(this.queryParams);
        }
        if (hashtable2 != null) {
            enumeration = hashtable2.keys();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("?");
            }
            while (enumeration.hasMoreElements()) {
                if (string4 != null) {
                    stringBuffer.append("&");
                }
                string4 = (String)enumeration.nextElement();
                String string5 = (String)hashtable2.get(string4);
                stringBuffer.append(URLEncoder.encode(string4, "UTF-8"));
                stringBuffer.append("=");
                stringBuffer.append(URLEncoder.encode(string5, "UTF-8"));
            }
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(string3);
        stringBuffer2.append(" ");
        stringBuffer2.append(stringBuffer.toString());
        stringBuffer2.append(" ");
        stringBuffer2.append(string2);
        stringBuffer2.append("\r\n");
        if (hashtable != null) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                if (string4.compareToIgnoreCase(HEADER_CONTENT_TYPE) == 0) {
                    bl = true;
                } else if (string4.compareToIgnoreCase(HEADER_CONNECTION) == 0) {
                    bl2 = true;
                }
                this.appendHeader(string4, (String)hashtable.get(string4), string, stringBuffer2);
            }
        }
        if (!bl) {
            stringBuffer2.append("Content-Type: text/xml; charset=utf-8\r\n");
        }
        if (!bl2) {
            stringBuffer2.append("Connection: close\r\n");
        }
        if (string != null) {
            stringBuffer2.append("Content-Length: " + string + "\r\n");
        }
        if (this.userInfo != null && this.userInfo.length() > 0) {
            stringBuffer2.append("Authorization: Basic " + this.internalBase64Encode(this.userInfo) + "\r\n");
        }
        if (this.proxyUserInfo != null && this.proxyUserInfo.length() > 0 && this.proxy) {
            stringBuffer2.append("Proxy-Authorization: Basic " + this.internalBase64Encode(this.proxyUserInfo) + "\r\n");
        }
        stringBuffer2.append("\r\n");
        return stringBuffer2;
    }

    protected StringBuffer generatePostHeaderRequest(Hashtable hashtable, String string, String string2) throws Exception {
        return this.generateHttpHeaderRequest(hashtable, null, string, string2, "POST");
    }

    protected StringBuffer generatePostHeaderRequest(Hashtable hashtable, Hashtable hashtable2, String string, String string2) throws Exception {
        return this.generateHttpHeaderRequest(hashtable, hashtable2, string, string2, "POST");
    }

    protected StringBuffer generateGetHeaderRequest(Hashtable hashtable, Hashtable hashtable2, String string, String string2) throws Exception {
        return this.generateHttpHeaderRequest(hashtable, hashtable2, null, string2, "GET");
    }

    protected byte[] processHTTPResponse(byte[] byArray) {
        byte[] byArray2 = null;
        for (int i = 0; i < byArray.length && byArray2 == null; ++i) {
            if (byArray[i] != 13 || byArray[i + 1] != 10 || byArray[i + 2] != 13 || byArray[i + 3] != 10) continue;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(byArray, i + 4, byArray.length - i - 4);
            byArray2 = byteArrayOutputStream.toByteArray();
        }
        return byArray2;
    }

    protected byte[] sendHttpSocket(byte[] byArray, byte[] byArray2) throws Exception {
        int n;
        Socket socket = this.getSocket();
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        dataOutputStream.write(byArray);
        if (byArray2 != null && byArray2.length > 0) {
            dataOutputStream.write(byArray2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray3 = new byte[16384];
        while ((n = dataInputStream.read(byArray3)) != -1) {
            byteArrayOutputStream.write(byArray3, 0, n);
        }
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        dataOutputStream.close();
        dataInputStream.close();
        socket.close();
        if (byArray4 == null) {
            throw new Exception("EmptyBodyResponse");
        }
        return byArray4;
    }

    protected byte[] sendHttpSocket(byte[] byArray) throws Exception {
        return this.sendHttpSocket(byArray, null);
    }

    public byte[] postSocket(byte[] byArray, Hashtable hashtable, Hashtable hashtable2) throws Exception {
        this.init();
        StringBuffer stringBuffer = this.generatePostHeaderRequest(hashtable, hashtable2, String.valueOf(byArray.length), "HTTP/1.0");
        byte[] byArray2 = stringBuffer.toString().getBytes("US-ASCII");
        return this.processHTTPResponse(this.sendHttpSocket(byArray2, byArray));
    }

    public byte[] postSocket(byte[] byArray, Hashtable hashtable) throws Exception {
        return this.postSocket(byArray, hashtable, null);
    }

    public byte[] post(byte[] byArray) throws Exception {
        return this.postSocket(byArray, null);
    }

    public byte[] get(Hashtable hashtable, Hashtable hashtable2) throws Exception {
        this.init();
        StringBuffer stringBuffer = this.generateGetHeaderRequest(hashtable, hashtable2, null, "HTTP/1.0");
        byte[] byArray = stringBuffer.toString().getBytes("US-ASCII");
        return this.processHTTPResponse(this.sendHttpSocket(byArray));
    }

    public void setProxy(boolean bl) {
        this.proxy = bl;
    }

    public void setProxyHost(String string) {
        this.proxyHost = string;
    }

    public void setProxyPort(String string) {
        this.proxyPort = string;
    }

    public void setProxyUserInfo(String string) {
        this.proxyUserInfo = string;
    }

    public void setUrl(String string) {
        this.urlStr = string;
    }

    public void setKeyPath(String string) {
        this.keyPath = string;
    }

    public void setKeyPwd(String string) {
        this.keyPwd = string;
    }

    public void setKeyType(String string) {
        this.keyType = string;
    }

    public void setTrustPath(String string) {
        this.trustPath = string;
    }

    public void setTrustPwd(String string) {
        this.trustPwd = string;
    }

    public void setUseKeystore(boolean bl) {
        this.useKeystore = bl;
    }

    public void setUseTrustStore(boolean bl) {
        this.useTrustStore = bl;
    }

    public void setUserInfo(String string) {
        this.userInfo = string;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public void setUseNoCheckNames(boolean bl) {
        this.useNoCheckNames = bl;
    }

    public void setValidationAlg(String string) {
        this.validationAlg = string;
    }
}

