/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.safelayer.trustedx.client.axis.DecodeBase64Block;
import com.safelayer.trustedx.client.axis.TagInfo;
import com.safelayer.trustedx.client.axis.TxAxisClientException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Random;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.HexBinary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Base64PackFilter
extends XMLFilterImpl {
    protected FileOutputStream fos;
    protected OutputStreamWriter osw;
    protected TagInfo currentActive;
    protected String name;
    protected DecodeBase64Block decode;
    protected String valueReqId;
    protected Random random;
    protected Hashtable tags;
    protected String savePath;
    protected boolean useRandomId;
    protected String atrReqId;
    protected boolean overwrite;

    public Base64PackFilter() {
    }

    public Base64PackFilter(XMLReader xMLReader) {
        super(xMLReader);
    }

    public void startDocument() throws SAXException {
        if (this.useRandomId) {
            this.random = new Random();
        }
        super.startDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            Object object;
            if (!this.useRandomId && this.valueReqId == null && attributes != null && attributes.getLength() > 0 && (object = attributes.getValue("", this.atrReqId)) != null) {
                this.valueReqId = object;
            }
            if ((object = (TagInfo)this.tags.get(string2)) != null) {
                String string4;
                Object object2;
                this.currentActive = object;
                this.currentActive.incrCount();
                if (this.valueReqId == null) {
                    if (!this.useRandomId) {
                        throw new TxAxisClientException("RequestIDRequiredNotFound");
                    }
                    object2 = new byte[10];
                    this.random.nextBytes((byte[])object2);
                    this.valueReqId = HexBinary.encode((byte[])object2);
                }
                object2 = new StringBuffer();
                ((StringBuffer)object2).append(this.valueReqId);
                ((StringBuffer)object2).append("-");
                ((StringBuffer)object2).append(string2);
                ((StringBuffer)object2).append("-");
                ((StringBuffer)object2).append(this.currentActive.getCount());
                this.name = ((StringBuffer)object2).toString();
                if (this.savePath == null || this.savePath.length() == 0) {
                    string4 = this.name;
                } else {
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append(this.savePath);
                    ((StringBuffer)object2).append(File.separator);
                    ((StringBuffer)object2).append(this.name);
                    string4 = ((StringBuffer)object2).toString();
                }
                File file = new File(string4);
                if (file.canRead() && !this.overwrite) {
                    throw new TxAxisClientException("ResponseFileAlreadyExists");
                }
                this.fos = new FileOutputStream(file);
                if (this.currentActive.isHandleAsBase64()) {
                    this.osw = new OutputStreamWriter((OutputStream)this.fos, "US-ASCII");
                } else {
                    this.decode = new DecodeBase64Block();
                    this.decode.init();
                }
            }
            super.startElement(string, string2, string3, attributes);
        }
        catch (Exception exception) {
            try {
                this.fos.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SAXException(exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentActive != null) {
            try {
                char[] cArray = Base64.encode((byte[])this.name.getBytes()).toCharArray();
                super.characters(cArray, 0, cArray.length);
                if (!this.currentActive.isHandleAsBase64()) {
                    this.decode.lastBlock();
                } else {
                    this.osw.flush();
                    this.osw.close();
                }
                this.fos.flush();
                this.currentActive = null;
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
            finally {
                try {
                    this.fos.close();
                }
                catch (Exception exception) {}
            }
        }
        super.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (this.currentActive == null) {
                super.characters(cArray, n, n2);
            } else if (this.currentActive.isHandleAsBase64()) {
                this.osw.write(cArray, n, n2);
            } else {
                byte[] byArray = this.decode.getBlock(cArray, n, n2);
                this.fos.write(byArray);
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
    }

    public void setSavePath(String string) {
        this.savePath = string;
    }

    public void setTags(Hashtable hashtable) {
        this.tags = hashtable;
    }

    public void setUseRandomId(boolean bl) {
        this.useRandomId = bl;
    }

    public void setAtrReqId(String string) {
        this.atrReqId = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }
}

