package net.aocat.psis.client.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;


/**
 * Utilities class.
 * @author aalcaide
 */
public class Utils {

	/**
	 * Prints an XMLObject (pretty print) and saves it to disk.
	 * @param xmlObj XMLObject to print
	 */
	public static void printXmlObject(XmlObject xmlObj, String filePath){
		//print request message
		printXmlObject(xmlObj);
		//save to file
		if(filePath!=null){
			FileOutputStream fos = null;
			try{
				File file = new File(filePath);
				fos = new FileOutputStream(file);
				fos.write(xmlObj.getDomNode().getTextContent().getBytes());
				fos.close();
			} catch (Exception e) {
				try{if(fos!=null) fos.close();} catch(Exception ex){}
				e.printStackTrace();
			}
		}
	}

	/**
	 * Prints an XMLObject (pretty print).
	 * @param xmlObj XMLObject to print
	 */
	public static void printXmlObject(XmlObject xmlObj){
		//print request message
		XmlOptions xmlOptions = new XmlOptions();
		xmlOptions.setSavePrettyPrint();
		xmlOptions.setSaveOuter();
		System.out.println(xmlObj);
	}

	/**
	 * Builds a certificate from the path of the file that contains it.
	 * @param path path of the file that contains the certificate
	 * @return java.security.X509Certificate
	 * @throws CertificateException
	 */
	public static X509Certificate getCertificate(String path) throws CertificateException {
		InputStream stream = ClassLoader.getSystemResourceAsStream(path);
		return (X509Certificate)CertificateFactory.getInstance(
		"X.509").generateCertificate(stream);
	}

    /**
     * Returns the contents of the file in a byte array.
     * @param path path of the file relative to classpath
     * @return byte[] contents of the file
     * @throws IOException
     */
    public static byte[] getBytesFromFile(String path) throws IOException {

    	InputStream is = ClassLoader.getSystemResourceAsStream(path);
        byte[] bytes = getBytes(is);
        is.close();

        return bytes;
    }

    /**
     * Returns the contents of the file in a byte array.
     * @param absPath absolute path of the file
     * @return byte[] contents of the file
     * @throws IOException
     */
    public static byte[] getBytesFromFileAbsPath(String absPath) throws IOException {

    	File file = new File(absPath);
    	FileInputStream fis = new FileInputStream(file);
        byte[] bytes = getBytes(fis);
        fis.close();

        return bytes;
    }

    /**
     * Gets a byte array from an InputStream.
     * @param is InputStream
     * @return byte[]
     * @throws IOException
     */
    public static byte[] getBytes(InputStream is) throws IOException {

    	ByteArrayOutputStream baos = new ByteArrayOutputStream();

    	int bytee;
    	while (-1!=(bytee=is.read()))
    	{
    	   baos.write(bytee);
    	}
    	baos.close();
    	byte[] bytes = baos.toByteArray();

        is.close();
        return bytes;
    }

    /**
     * Saves byte[] to a file.
     * @param data data to save
     * @param fileAbsolutePath absolute path of the file where to save the data
     * @throws IOException
     */
    public static void saveToFile (byte[] data, String fileAbsolutePath) throws IOException{
    	File f = new File(fileAbsolutePath);
		FileOutputStream fos = new FileOutputStream(f);
		fos.write(data);
		fos.close();
    }

}
