package net.aocat.psis.client.utils;

/**
 * Signature and timestamp types.
 * @author aalcaide
 */
public class Types {

	/** Signature types */
	public static class Signature{
		
		/** CMS simple signature */
		public static String CMS = "urn:ietf:rfc:3852";
		/** CAdES (CMS Advanced) signature */
		public static String CAdES = "http://uri.etsi.org/01733/v1.6.3#";
		/** XML simple signature */
		public static String XMLDSig = "urn:ietf:rfc:3275";
		/** XAdES (XML advanced) signature */
		public static String XAdES = "http://uri.etsi.org/01903/v1.2.2#";
		
	}
	
	/** Timestamp types */
	public static class TimeStamp{
		
		/** RFC3161 timestamp */
		public static String CMS = "urn:ietf:rfc:3161";
		/** XML timestamp */
		public static String XML = "oasis:names:tc:dss:1.0:core:schema:XMLTimeStampToken";
		/** XAdES timestamp */
		public static String XAdES = "oasis:names:tc:dss:1.0:core:schema:XAdESTimeStampToken";
		
	}
	
}
