package net.aocat.psis.client.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * Signature attributes.
 * @author aalcaide
 */
public class SignatureAttributes {

	//profiles prefixes
	private static String XSSPrefix = "urn:oasis:names:tc:dss:1.0:profiles:XSS:signatureAttributes:";

	//generic attributes
	/** Signature's digest algorithm */
	public static String DigestAlgorithm = XSSPrefix+"DigestAlgorithm";
	/** Signature digest encryption algorithm */
	public static String DigestEncryptionAlgorithm = XSSPrefix+"DigestEncryptionAlgorithm";
	/** Signature algorithm */
	public static String SignatureAlgorithm = XSSPrefix+"SignatureAlgorithm";
	/** Signature value */
	public static String SignatureValue = XSSPrefix+"SignatureValue";
	/** Signature expiration date */
	public static String ExpirationDate = XSSPrefix+"SignatureExpirationDate";

	/**
	 * Returns a list with all the attributes.
	 * @return list with all the attributes
	 */
	public static List<String> getAllAttributes(){

		List<String> attributes = new ArrayList<String>();

		attributes.add(SignatureAttributes.DigestAlgorithm);
		attributes.add(SignatureAttributes.DigestEncryptionAlgorithm);
		attributes.add(SignatureAttributes.SignatureAlgorithm);
		attributes.add(SignatureAttributes.SignatureValue);
		attributes.add(SignatureAttributes.ExpirationDate);

		return attributes;
	}

	/**
	 * Returns a list with the always expected attributes.
	 * @return list with the always expected attributes
	 */
	public static List<String> getGenericAttributes(){

		List<String> attributes = new ArrayList<String>();

		attributes.add(SignatureAttributes.DigestAlgorithm);
		attributes.add(SignatureAttributes.DigestEncryptionAlgorithm);
		attributes.add(SignatureAttributes.SignatureAlgorithm);

		return attributes;
	}

	/**
	 * Builds a HashMap containing translated meaningful attribute descriptions.
	 * @return HashMap containing translated meaningful attribute descriptions.
	 */
	public static HashMap<String,String> initAttrsHM(){
		HashMap<String,String> attrs = new HashMap<String,String>();
		attrs.put(SignatureAttributes.DigestAlgorithm, "Algorisme de resum");
		attrs.put(SignatureAttributes.DigestEncryptionAlgorithm, "Algorisme d'encriptaci del resum");
		attrs.put(SignatureAttributes.SignatureAlgorithm, "Algorisme de signatura");
		attrs.put(SignatureAttributes.SignatureValue, "Valor de la signatura");
		attrs.put(SignatureAttributes.ExpirationDate, "Data de caducitat de la signatura");
		return attrs;
	}
	
}
