package net.aocat.psis.client.utils;

/**
 * PSIS results codes.
 * @author aalcaide
 */
public class Results {

	private static String majorPrefix = "urn:oasis:names:tc:dss:1.0:resultmajor:";
	private static String minorPrefix = "urn:oasis:names:tc:dss:1.0:resultminor:";
	private static String minorPrefixXSS = "urn:oasis:names:tc:dss:1.0:profiles:XSS:resultminor:";	
	
	/**
	 * PSIS major result codes.
	 */
	public static class Majors{
		/** The protocol executed successfully. */
		public static String Success = majorPrefix+"Success";
		/** The request could not be satisfied due to an error on the part of the requester. */
		public static String RequesterError = majorPrefix+"RequesterError";
		/** The request could not be satisfied due to an error on the part of the responder. */
		public static String ResponderError = majorPrefix+"ResponderError";
	}
	
	/**
	 * PSIS minor result codes.
	 */
	public static class Minors{
	
		
		/** Internal Server Error code */
		public static String InternalServerError = "urn:oasis:names:tc:dss:1.0:resultminor:InternalServerError";
		
		/**
		 * PSIS validation result codes.
		 */
		public static class Validation{
			
			/**
			 * PSIS certificate validation result codes.
			 */
			public static class Certificate{
				/** Certificate is valid. */
				public static String VALID = minorPrefixXSS+"valid:certificate:Definitive";
				/** Certificate is revoked. */
				public static String REVOKED = minorPrefixXSS+"invalid:certificate:Revoked";
				/** Certificate is expired. */
				public static String EXPIRED = minorPrefixXSS+"invalid:certificate:Expired";
			}
			
			/**
			 * PSIS signature and timestamp validation result codes.
			 */
			public static class Signature{

				/** All signatures are valid. */
				public static String VALID_MULTISIGNATURES = minorPrefix+"ValidMultiSignatures";
				/** The signature or timestamp is valid. Furthermore, the signature or timestamp covers all of the input documents just as they were passed in by the client. */
				public static String VALID_ONALLDOCS = minorPrefix+"valid:signature:onAllDocuments";
				/** The signature or timestamp is valid. Furthermore, the signature or timestamp covers all of the input transformed documents passed in by the client. */
				public static String VALID_ONTRANSFORMEDDOCS = minorPrefix+"valid:signature:onTransformedDocuments";
				/** The signature or timestamp is valid. However, the signature or timestamp does not cover all of the input documents that were passed in by the client. */
				public static String VALID_NOTALLDOCSREFERENCED = minorPrefix+"valid:signature:notAllDocumentsReferenced";
				
				/** The signature or timestamp is invalid.  */
				public static String INVALID = minorPrefix+"invalid:signature";
				/** The signature or timestamp is incorrect. It fails to verify, for example due to the signed document being modified or the incorrect key being used. */
				public static String INVALID_INCORRECT = minorPrefix+"invalid:incorrectSignature";
				/** The signature or timestamp is invalid because the referenced document is not present. */
				public static String INVALID_REFERENCEDDOCSNOTPRESENT = minorPrefix+"invalid:refencedDocumentNotPresent";
				/** The signature or timestamp is invalid because signing key could not be validated. */
				public static String INVALID_INDETERMINATEKEY = minorPrefix+"invalid:indeterminateKey";
				/** The signature or timestamp is invalid because signing key is not trusted. */
				public static String INVALID_UNTRUSTEDKEY = minorPrefix+"invalid:untrustedKey";
				
				/** The signature or its contents are not appropriate in the current context. For example, the signature may be associated with a signature policy and semantics which the DSS server considers unsatisfactory. */
				public static String INAPPROPRIATE = minorPrefix+"inappropriate:signature";
				/** The DSS server could not determine the validity of the signature or timestamp. Further information is provided in textual form. */
				public static String INDETERMINED = minorPrefix+"indetermined:checkOptionalOutputs";
				
				/** The DSS server could not determine signature's PDU validity. */
				public static String CANNOTDETERMINEPDUVALIDITY = minorPrefix+"CannotDeterminePDUValidity";
			}
			
		}
	
	}
	
}
