package net.aocat.psis.client.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * PDF signature attributes.
 * @author aalcaide
 */
public class PDFSignatureAttributes {

	//profiles prefix
	private static String DSSPDFPrefix = "urn:oasis:names:tc:dss:1.0:profiles:DSS_PDF:signatureAttributes:";

	//PDF signature attributes
	/** Reason of the signature */
	public static String Reason = DSSPDFPrefix+"Reason";
	/** Location where the signature was produced. */
	public static String Location = DSSPDFPrefix+"Location";
	/** Name of the signer. */
	public static String SignerName = DSSPDFPrefix+"SignerName";
	/** Contact info. */
	public static String ContactInfo = DSSPDFPrefix+"ContactInfo";


	/**
	 * Returns a list with all the attributes.
	 * @return list with all the attributes
	 */
	public static List<String> getAllAttributes(){

		List<String> attributes = new ArrayList<String>();

		attributes.add(PDFSignatureAttributes.Reason);
		attributes.add(PDFSignatureAttributes.Location);
		attributes.add(PDFSignatureAttributes.SignerName);
		attributes.add(PDFSignatureAttributes.ContactInfo);

		return attributes;
	}

	/**
	 * Builds a HashMap containing translated meaningful attribute descriptions.
	 * @return HashMap containing translated meaningful attribute descriptions.
	 */
	public static HashMap<String,String> initAttrsHM(){
		HashMap<String,String> attrs = new HashMap<String,String>();
		attrs.put(PDFSignatureAttributes.Reason, "Ra");
		attrs.put(PDFSignatureAttributes.Location, "Localitzaci");
		attrs.put(PDFSignatureAttributes.SignerName, "Nom del signatari");
		attrs.put(PDFSignatureAttributes.ContactInfo, "Contacte");
		return attrs;
	}

}
