package net.aocat.psis.client.utils;

import java.math.BigInteger;

/**
 * Class for converting the certificate's serial (due to the size of the serial, it works with BigIntegers):
 * <br/>- from decimal to hexadecimal
 * <br/>- from hexadecimal to decimal.
 * @author aalcaide
 */
public class CertificateSerialConverter {

	/**
	 * Converts a decimal serial to its hexadecimal representation.
	 * @param serial decimal serial to convert
	 * @return hexadecimal representation of the serial
	 */
	public static String convertDecSerial2Hex(String serial)
    {
        BigInteger bi = new BigInteger(serial, 10);
        return bi.toString(16);
    }

	/**
	 * Converts a hexadecimal serial to its decimal representation.
	 * @param serial hexadecimal serial to convert
	 * @return decimal representation of the serial
	 */
	public static String convertHexSerial2Dec(String serial){
		BigInteger bi = new BigInteger(serial, 16);
		return bi.toString(10);
	}	
	 
	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception{
		
		String decSerial = "75489462122282675823039751465172539031";
		String hexSerial = "38cabdd6ca785d45536c7d5bc5451697";
		
		String converted2HexSerial = convertDecSerial2Hex(decSerial);
		String converted2DecSerial = convertHexSerial2Dec(hexSerial);
		
		System.out.println(converted2HexSerial);
		System.out.println(converted2DecSerial);
		
		if(!converted2HexSerial.equalsIgnoreCase(hexSerial))
			throw new Exception("Error: "+converted2HexSerial+" "+hexSerial);
		if(!converted2DecSerial.equalsIgnoreCase(decSerial))
			throw new Exception("Error: "+converted2DecSerial+" "+decSerial);
		
	}
	
	
}
