package net.aocat.psis.client.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * PSIS parsed certificate attributes.
 * @author aalcaide
 */
public class CertificateAttributes {
	
	//profiles prefixes
	private static String XSSPrefix = "urn:oasis:names:tc:dss:1.0:profiles:XSS:certificateAttributes:";
	private static String CATCertPrefix = "urn:catcert:psis:certificateAttributes:";
	private static String CATCertProfAsocPrefix = CATCertPrefix+"professionalAssociations:";
	private static String CATCertNotariesPrefix = CATCertPrefix+"notaries:";
	
	//generic attributes
	/** Version  */
	public static String Version = XSSPrefix+"Version";
	/** Serial Number  */
	public static String SerialNumber = XSSPrefix+"SerialNumber";
	/** Signature */
	public static String Signature = XSSPrefix+"Signature";
	/** Signature algorithm */
	public static String SignatureAlgorithm = XSSPrefix+"SignatureAlgorithm";
	/** Issuer Distinguished Name */
	public static String IssuerDistinguishedName = XSSPrefix+"IssuerDistinguishedName";
	/** Subject Distinguished Name  */
	public static String SubjectDistinguishedName = XSSPrefix+"SubjectDistinguishedName";
	/** Certificate's issue date */
	public static String NotBefore = XSSPrefix+"NotBefore";
	/** Certificate's expiration date */
	public static String NotAfter = XSSPrefix+"NotAfter";
	/** Subject public key algorithm */
	public static String SubjectPublicKeyAlgorithm = XSSPrefix+"SubjectPublicKeyAlgorithm";
	/** Subject public key */
	public static String SubjectPublicKey = XSSPrefix+"SubjectPublicKey";
	/** Extension */
	public static String Extension = XSSPrefix+"Extension:";
	
	//old VA
	/** Issuer Distinguished Name: common name */
	public static String IssuerDistinguishedName_commonName = XSSPrefix+"IssuerDistinguishedName:commonName";
	/** Subject e-mail */
	public static String SubjectEmail = XSSPrefix+"SubjectEmail";
	/** Certificate policies */
	public static String CertificatePolicies = XSSPrefix+"CertificatePolicies";
	/** Key usages */
	public static String KeyUsages = XSSPrefix+"KeyUsages";
	/** Subject Distinguished Name: serial number */
	public static String SubjectDistinguishedName_serialNumber = XSSPrefix+"SubjectDistinguishedName:serialNumber";
	/** Subject Distinguished Name: common name */
	public static String SubjectDistinguishedName_commonName = XSSPrefix+"SubjectDistinguishedName:commonName";
	/** Subject Distinguished Name: given name */
	public static String SubjectDistinguishedName_givenName = XSSPrefix+"SubjectDistinguishedName:givenName";
	/** Subject Distinguished Name: surname */
	public static String SubjectDistinguishedName_surname = XSSPrefix+"SubjectDistinguishedName:surname";
	/** Subject Distinguished Name: title */
	public static String SubjectDistinguishedName_title = XSSPrefix+"SubjectDistinguishedName:title";
	/** Subject Distinguished Name: organization name */
	public static String SubjectDistinguishedName_organizationName = XSSPrefix+"SubjectDistinguishedName:organizationName";
	/** Subject Distinguished Name: organization unit name */
	public static String SubjectDistinguishedName_organizationUnitName = XSSPrefix+"SubjectDistinguishedName:organizationUnitName";
	/** Subject Distinguished Name: country */
	public static String SubjectDistinguishedName_countryName = XSSPrefix+"SubjectDistinguishedName:countryName";
	/** Subject Distinguished Name: state or province */
	public static String SubjectDistinguishedName_stateOrProvinceName = XSSPrefix+"SubjectDistinguishedName:stateOrProvinceName";
	
	//CATCert specific
	/** Key owner NIF */
	public static String KeyOwnerNIF = CATCertPrefix+"KeyOwnerNIF";
	/** Legal entity CIF */
	public static String LegalEntityCIF = CATCertPrefix+"LegalEntityCIF";
	/** Legal entity global CIF */
	public static String LegalEntityGlobalCIF = CATCertPrefix+"LegalEntityGlobalCIF";
	/** Department */
	public static String Department = CATCertPrefix+"Department";
	/** Subject name */
	public static String SubjectName = CATCertPrefix+"SubjectName";
	/** Qualitative usage limitations */
	public static String QualitativeUsageLimitations = CATCertPrefix+"QualitativeUsageLimitations";
	/** Quantitative usage limitations */
	public static String QuantitativeUsageLimitations = CATCertPrefix+"QuantitativeUsageLimitations";
	/** Classification level */
	public static String ClassificationLevel = CATCertPrefix+"ClassificationLevel";
	/** Title */
	public static String Title = CATCertPrefix+"Title";
	/** Attribute */
	public static String Attribute = CATCertPrefix+"Attribute";
	/** Vinculated person: full name */
	public static String VinculatedPersonFullName = CATCertPrefix+"VinculatedPersonFullName";
	/** Vinculated person: name */
	public static String VinculatedPersonName = CATCertPrefix+"VinculatedPersonName";
	/** Vinculated person: surname */
	public static String VinculatedPersonSurname = CATCertPrefix+"VinculatedPersonSurname";
	/** Vinculated person: NIF or NIE */
	public static String VinculatedPersonNIForNIE = CATCertPrefix+"VinculatedPersonNIForNIE";
	/** Vinculated company: CIF */
	public static String VinculatedCompanyCIF = CATCertPrefix+"VinculatedCompanyCIF";
	/** Vinculated company: name */
	public static String VinculatedCompanyName = CATCertPrefix+"VinculatedCompanyName";
	/** Issuer Certificate Authority */
	public static String issuerCA = CATCertPrefix+"issuerCA";
	/** Legal document type */
	public static String LegalDocumentType = CATCertPrefix+"LegalDocumentType";
	/** Certificate Type */
	public static String CertificateType = CATCertPrefix+"CertificateType";

	//CATCert specific Professional Associations
	/** Professional association: name */
	public static String ProfessionalAssociationName = CATCertProfAsocPrefix+"ProfessionalAssociationName";
	/** Professional association: initials */
	public static String ProfessionalAssociationInitials = CATCertProfAsocPrefix+"ProfessionalAssociationInitials";
	/** Professional association: number */
	public static String ProfessionalAssociationNumber = CATCertProfAsocPrefix+"ProfessionalAssociationNumber";
	/** Professional association: zone */
	public static String ProfessionalAssociationZone = CATCertProfAsocPrefix+"ProfessionalAssociationZone";
	/** Professional association: employee number */
	public static String ProfessionalAssociationEmployeeNumber = CATCertProfAsocPrefix+"ProfessionalAssociationEmployeeNumber";
	/** Professional association: CIF */
	public static String ProfessionalAssociationCIF = CATCertProfAsocPrefix+"ProfessionalAssociationCIF";
	
	//CATCert specific Notaries
	/** Notaries: authorizing notary */
	public static String AuthorizingNotary = CATCertNotariesPrefix+"AuthorizingNotary";
	/** Notaries: entitlements registry location data */
	public static String EntitlementsRegistryLocationData = CATCertNotariesPrefix+"EntitlementsRegistryLocationData";
	/** Notaries: representation document location data */
	public static String RepresentationDocumentLocationData = CATCertNotariesPrefix+"RepresentationDocumentLocationData";
	
	
	/**
	 * Builds a HashMap containing translated meaningful attributes descriptions.
	 * @return HashMap containing translated meaningful attributes descriptions.
	 */
	public static HashMap<String,String> initAttrsHM(){
		HashMap<String,String> attrs = new HashMap<String,String>();
		attrs.put(CertificateAttributes.Version, "Versi");
		attrs.put(CertificateAttributes.SerialNumber, "Nmero de srie");
		attrs.put(CertificateAttributes.Signature, "Signatura");
		attrs.put(CertificateAttributes.SignatureAlgorithm, "Algorisme de la signatura");
		attrs.put(CertificateAttributes.IssuerDistinguishedName, "Emisor");
		attrs.put(CertificateAttributes.SubjectDistinguishedName, "Assumpte");
		attrs.put(CertificateAttributes.NotBefore, "Vlid des de");
		attrs.put(CertificateAttributes.NotAfter, "Vlid fins a");
		attrs.put(CertificateAttributes.SubjectPublicKeyAlgorithm, "Subjecte: Algorisme de clau pblica");
		attrs.put(CertificateAttributes.SubjectPublicKey, "Subjecte: Clau pblica");
		attrs.put(CertificateAttributes.Extension, "Extensi");
		attrs.put(CertificateAttributes.IssuerDistinguishedName_commonName, "Emisor: Nom");
		attrs.put(CertificateAttributes.SubjectEmail, "Subjecte: e-mail");
		attrs.put(CertificateAttributes.CertificatePolicies, "Poltiques del certificat");
		attrs.put(CertificateAttributes.KeyUsages, "Usos de la clau");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_organizationName, "Subjecte: Organitzaci");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_serialNumber, "Subjecte: Nmero de srie");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_commonName, "Subjecte: Nom com");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_givenName, "Subjecte: Nom");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_surname, "Subjecte: Cognoms");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_title, "Subjecte: Ttol");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_organizationUnitName, "Subjecte: Departament");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_countryName, "Subjecte: Pas");
		attrs.put(CertificateAttributes.SubjectDistinguishedName_stateOrProvinceName, "Subjecte: Provncia");
		attrs.put(CertificateAttributes.KeyOwnerNIF, "Subjecte: NIF");
		attrs.put(CertificateAttributes.LegalEntityCIF, "Organitzaci: CIF");
		attrs.put(CertificateAttributes.LegalEntityGlobalCIF, "Organitzaci: CIF");
		attrs.put(CertificateAttributes.Department, "Departament");
		attrs.put(CertificateAttributes.SubjectName, "Subjecte: Nom");
		attrs.put(CertificateAttributes.QualitativeUsageLimitations, "Limitacions qualitatives d's");
		attrs.put(CertificateAttributes.QuantitativeUsageLimitations, "Limitacions quantitatives d's");
		attrs.put(CertificateAttributes.ClassificationLevel, "Classificaci");
		attrs.put(CertificateAttributes.Title, "Ttol");
		attrs.put(CertificateAttributes.Attribute, "Atribut");
		attrs.put(CertificateAttributes.VinculatedPersonFullName,"Subjecte: Nom sencer");
		attrs.put(CertificateAttributes.VinculatedPersonName,"Subjecte: Nom");
		attrs.put(CertificateAttributes.VinculatedPersonSurname,"Subjecte: Cognom");
		attrs.put(CertificateAttributes.VinculatedPersonNIForNIE,"Subjecte: NIF o NIE");
		attrs.put(CertificateAttributes.VinculatedCompanyCIF,"Empresa: CIF");
		attrs.put(CertificateAttributes.VinculatedCompanyName,"Empresa: Nom");
		attrs.put(CertificateAttributes.issuerCA,"Emisor");
		attrs.put(CertificateAttributes.LegalDocumentType,"Tipus de document legal");
		attrs.put(CertificateAttributes.CertificateType,"Tipus de certificat");
		attrs.put(CertificateAttributes.ProfessionalAssociationName, "Associaci professional: Nom");
		attrs.put(CertificateAttributes.ProfessionalAssociationInitials, "Associaci professional: Inicials");
		attrs.put(CertificateAttributes.ProfessionalAssociationNumber, "Associaci professional: Nmero");
		attrs.put(CertificateAttributes.ProfessionalAssociationZone, "Associaci professional: Zona");
		attrs.put(CertificateAttributes.ProfessionalAssociationEmployeeNumber, "Associaci professional: Nmero d'empleat");
		attrs.put(CertificateAttributes.ProfessionalAssociationCIF, "Associaci professional: CIF");
		attrs.put(CertificateAttributes.AuthorizingNotary, "Notaries: Notari autoritzant");
		attrs.put(CertificateAttributes.EntitlementsRegistryLocationData, "Notaries: Registre de drets");
		attrs.put(CertificateAttributes.RepresentationDocumentLocationData, "Notaries: Registre de documents de representaci");
		return attrs;
	}
	
	
	/**
	 * Returns a list with all the attributes.
	 * @return list with all the attributes
	 */
	public static List<String> getAllAttributes(){
		
		List<String> attributes = new ArrayList<String>();
		
		attributes.add(CertificateAttributes.Version);
		attributes.add(CertificateAttributes.SerialNumber);
		attributes.add(CertificateAttributes.Signature);
		attributes.add(CertificateAttributes.SignatureAlgorithm);
		attributes.add(CertificateAttributes.IssuerDistinguishedName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName);
		attributes.add(CertificateAttributes.NotBefore);
		attributes.add(CertificateAttributes.NotAfter);
		attributes.add(CertificateAttributes.SubjectPublicKeyAlgorithm);
		attributes.add(CertificateAttributes.SubjectPublicKey);
		attributes.add(CertificateAttributes.Extension);
		attributes.add(CertificateAttributes.IssuerDistinguishedName_commonName);
		attributes.add(CertificateAttributes.SubjectEmail);
		attributes.add(CertificateAttributes.CertificatePolicies);
		attributes.add(CertificateAttributes.KeyUsages);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_organizationName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_serialNumber);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_commonName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_givenName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_surname);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_title);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_organizationUnitName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_countryName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_stateOrProvinceName);
		attributes.add(CertificateAttributes.KeyOwnerNIF);
		attributes.add(CertificateAttributes.LegalEntityCIF);
		attributes.add(CertificateAttributes.LegalEntityGlobalCIF);
		attributes.add(CertificateAttributes.Department);
		attributes.add(CertificateAttributes.SubjectName);
		attributes.add(CertificateAttributes.QualitativeUsageLimitations);
		attributes.add(CertificateAttributes.QuantitativeUsageLimitations);
		attributes.add(CertificateAttributes.ClassificationLevel);
		attributes.add(CertificateAttributes.Title);
		attributes.add(CertificateAttributes.Attribute);
		attributes.add(CertificateAttributes.VinculatedPersonFullName);
		attributes.add(CertificateAttributes.VinculatedPersonName);
		attributes.add(CertificateAttributes.VinculatedPersonSurname);
		attributes.add(CertificateAttributes.VinculatedPersonNIForNIE);
		attributes.add(CertificateAttributes.VinculatedCompanyCIF);
		attributes.add(CertificateAttributes.VinculatedCompanyName);
		attributes.add(CertificateAttributes.issuerCA);
		attributes.add(CertificateAttributes.LegalDocumentType);
		attributes.add(CertificateAttributes.CertificateType);
		attributes.add(CertificateAttributes.ProfessionalAssociationName);
		attributes.add(CertificateAttributes.ProfessionalAssociationInitials);
		attributes.add(CertificateAttributes.ProfessionalAssociationNumber);
		attributes.add(CertificateAttributes.ProfessionalAssociationZone);
		attributes.add(CertificateAttributes.ProfessionalAssociationEmployeeNumber);
		attributes.add(CertificateAttributes.ProfessionalAssociationCIF);
		attributes.add(CertificateAttributes.AuthorizingNotary);
		attributes.add(CertificateAttributes.EntitlementsRegistryLocationData);
		attributes.add(CertificateAttributes.RepresentationDocumentLocationData);
		
		return attributes;
	}
	
	/**
	 * Returns a list with the allways expected attributes.
	 * @return list with the allways expected attributes
	 */
	public static List<String> getGenericAttributes(){
		
		List<String> attributes = new ArrayList<String>();
		
		attributes.add(CertificateAttributes.Version);
		attributes.add(CertificateAttributes.SerialNumber);
		attributes.add(CertificateAttributes.Signature);
		attributes.add(CertificateAttributes.SignatureAlgorithm);
		attributes.add(CertificateAttributes.IssuerDistinguishedName);
		attributes.add(CertificateAttributes.IssuerDistinguishedName_commonName);
		attributes.add(CertificateAttributes.NotBefore);
		attributes.add(CertificateAttributes.NotAfter);
		attributes.add(CertificateAttributes.SubjectPublicKeyAlgorithm);
		attributes.add(CertificateAttributes.SubjectPublicKey);
		attributes.add(CertificateAttributes.SubjectEmail);
		attributes.add(CertificateAttributes.CertificatePolicies);
		attributes.add(CertificateAttributes.CertificateType);
		attributes.add(CertificateAttributes.KeyUsages);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_serialNumber);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_commonName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_givenName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_surname);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_title);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_organizationUnitName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_countryName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_stateOrProvinceName);
		
		return attributes;
	}
	
	/**
	 * Returns a list with the CatCert specific attributes.
	 * @return list with the CatCert specific attributes
	 */
	public static List<String> getCATCertSpecificAttributes(){
		
		List<String> attributes = new ArrayList<String>();
		
		attributes.add(CertificateAttributes.KeyOwnerNIF);
		attributes.add(CertificateAttributes.LegalEntityCIF);
		attributes.add(CertificateAttributes.LegalEntityGlobalCIF);
		attributes.add(CertificateAttributes.Department);
		attributes.add(CertificateAttributes.SubjectName);
		attributes.add(CertificateAttributes.QualitativeUsageLimitations);
		attributes.add(CertificateAttributes.QuantitativeUsageLimitations);
		attributes.add(CertificateAttributes.ClassificationLevel);
		attributes.add(CertificateAttributes.CertificateType);
		attributes.add(CertificateAttributes.Title);
		attributes.add(CertificateAttributes.Attribute);
		attributes.add(CertificateAttributes.VinculatedPersonFullName);
		attributes.add(CertificateAttributes.VinculatedPersonName);
		attributes.add(CertificateAttributes.VinculatedPersonSurname);
		attributes.add(CertificateAttributes.VinculatedPersonNIForNIE);
		attributes.add(CertificateAttributes.VinculatedCompanyCIF);
		attributes.add(CertificateAttributes.VinculatedCompanyName);
		attributes.add(CertificateAttributes.issuerCA);
		attributes.add(CertificateAttributes.LegalDocumentType);
		
		return attributes;
	}
	
	/**
	 * Returns a list with the CatCert Professional Associations specific attributes.
	 * @return list with the CatCert Professional Associations specific attributes
	 */
	public static List<String> getCATCertProfAsocSpecificAttributes(){
		
		List<String> attributes = new ArrayList<String>();
		
		attributes.add(CertificateAttributes.ProfessionalAssociationName);
		attributes.add(CertificateAttributes.ProfessionalAssociationInitials);
		attributes.add(CertificateAttributes.ProfessionalAssociationNumber);
		attributes.add(CertificateAttributes.ProfessionalAssociationZone);
		attributes.add(CertificateAttributes.ProfessionalAssociationEmployeeNumber);
		attributes.add(CertificateAttributes.ProfessionalAssociationCIF);
		
		return attributes;
	}
	
	/**
	 * Returns a list with the CatCert Notaries specific attributes.
	 * @return list with the CatCert Notaries specific attributes
	 */
	public static List<String> getCATCertNotariesSpecificAttributes(){
		
		List<String> attributes = new ArrayList<String>();
		
		attributes.add(CertificateAttributes.AuthorizingNotary);
		attributes.add(CertificateAttributes.EntitlementsRegistryLocationData);
		attributes.add(CertificateAttributes.RepresentationDocumentLocationData);
		
		return attributes;
	}
	
	/**
	 * Returns a list with some of the most required attributes.
	 * @return list with attributes
	 */
	public static List<String> getSomeImportantAttributes(){
		
		List<String> attributes = new ArrayList<String>();
		
		attributes.add(CertificateAttributes.SerialNumber);
		attributes.add(CertificateAttributes.NotBefore);
		attributes.add(CertificateAttributes.NotAfter);
		attributes.add(CertificateAttributes.CertificatePolicies);
		attributes.add(CertificateAttributes.ClassificationLevel);
		attributes.add(CertificateAttributes.CertificateType);
		attributes.add(CertificateAttributes.KeyUsages);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_serialNumber);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_commonName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_givenName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_surname);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_title);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_organizationName);
		attributes.add(CertificateAttributes.SubjectDistinguishedName_organizationUnitName);
		attributes.add(CertificateAttributes.SubjectEmail);
		attributes.add(CertificateAttributes.IssuerDistinguishedName);
		attributes.add(CertificateAttributes.IssuerDistinguishedName_commonName);
		
		return attributes;
	}
	
}
