package net.aocat.psis.client.samples.timestamp.verify;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;

import net.aocat.psis.client.base.AbstractSample;
import net.aocat.psis.client.utils.Profiles;

import org.apache.commons.io.FileUtils;
import org.apache.xmlbeans.XmlException;
import org.w3.x2000.x09.xmldsig.DigestMethodType;
import org.w3.x2000.x09.xmldsig.SignatureType;

import x0CoreSchema.oasisNamesTcDss1.SignatureObjectType;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument;
import x0CoreSchema.oasisNamesTcDss1.VerifyResponseDocument;
import x0CoreSchema.oasisNamesTcDss1.DocumentHashDocument.DocumentHash;
import x0CoreSchema.oasisNamesTcDss1.InputDocumentsDocument.InputDocuments;
import x0CoreSchema.oasisNamesTcDss1.TimestampDocument.Timestamp;
import x0CoreSchema.oasisNamesTcDss1.VerifyRequestDocument.VerifyRequest;

/**
 * Java code sample for XML timestamp validation.
 * @author aalcaide
 */
public class XMLTimestampValidationSample extends AbstractSample {

	private boolean PRINT_REQUEST = true;
	private boolean PRINT_RESPONSE = true;
	private String OUT_DIR = "out\\";
	private boolean SAVE_REQUEST_AND_RESPONSE = true;
	private String VERIFY_REQUEST = "XML-Timestamp-VerifyRequest.xml";
	private String VERIFY_RESPONSE = "XML-Timestamp-VerifyResponse.xml";

	public XMLTimestampValidationSample(){
		super();
	}

	/**
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args){
		try{
			File signature = new File("resources\\timestamp\\xml\\XMLTimestamp.xml");
			File data = new File("resources\\timestamp\\xml\\hash.bin");
			XMLTimestampValidationSample validation = new XMLTimestampValidationSample();
			validation.verifyTimestamp(signature, data);
		} catch(Exception e){
			e.printStackTrace();
		}
	}

	/**
	 * Verifies an XML timestamp. Prints and/or saves request and response.
	 * @param signature timestamp to validate
	 * @param dataHash data hash to validate the timestamp against
	 * @throws XmlException 
	 * @throws IOException
	 */
	public void verifyTimestamp(File signature, File dataHash) throws IOException, XmlException {

		this.log.info("Start validation "+Profiles.TIMESTAMPING);

		this.log.debug("Start reading File "+signature.getAbsolutePath());
		byte[] tsBytes = FileUtils.readFileToByteArray(signature);

		this.log.debug("Start reading File "+dataHash.getAbsolutePath());
		byte[] docBytes = FileUtils.readFileToByteArray(dataHash);

		this.log.debug("Start message creation ");

		//VerifyRequest
		VerifyRequestDocument verifyRequest = VerifyRequestDocument.Factory.newInstance();
		VerifyRequest request = verifyRequest.addNewVerifyRequest();
		//TIMESTAMPING Profile
		request.setProfile(Profiles.TIMESTAMPING);

		//timestamp
		SignatureObjectType signObj = request.addNewSignatureObject();
		Timestamp timestamp = signObj.addNewTimestamp();
		timestamp.set(SignatureType.Factory.parse(new ByteArrayInputStream(tsBytes)));

		//input documents
		InputDocuments inDocs = request.addNewInputDocuments();
		DocumentHash doc = inDocs.addNewDocumentHash();
		DigestMethodType digMethod = doc.addNewDigestMethod();
		digMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
		doc.setDigestValue(docBytes);

		//print and save request
		printSaveRequest(PRINT_REQUEST, verifyRequest, SAVE_REQUEST_AND_RESPONSE, OUT_DIR, VERIFY_REQUEST);

		//send request to PSIS
		this.log.debug("Send timestamp validation request");		
		//VerifyResponse
		VerifyResponseDocument verifyResponse = this.factory.getDssPort().verify(verifyRequest);

		//print and save response
		printSaveResponse(PRINT_RESPONSE, verifyResponse, SAVE_REQUEST_AND_RESPONSE, OUT_DIR, VERIFY_RESPONSE);

	}

}
