package net.aocat.psis.client.base;

import javax.xml.namespace.QName;

import net.aocat.psis.client.DigitalSignatureService;
import net.aocat.psis.client.SOAPport;
import net.aocat.psis.client.config.PsisClientFactoryConfigurable;

import org.apache.log4j.Logger;


public class PsisClientFactory {

	private static Logger log = Logger.getLogger(PsisClientFactory.class);
	private static QName psisDssPortName = new QName("urn:service", "PsisDssPortSoap");
	private static QName psisDssPdfPortName = new QName("urn:service", "PsisDssPDFPortSoap");
	private DigitalSignatureService service;
	private PsisClientFactoryConfigurable configurator;

	public PsisClientFactoryConfigurable getConfigurator() {
		return this.configurator;
	}

	public void setConfigurator(PsisClientFactoryConfigurable configurator) {
		this.configurator = configurator;
		init();
	}

	public SOAPport getDssPort(){
		log.info("Getting DSS soap port");
		SOAPport port = this.service.getPort(PsisClientFactory.psisDssPortName, SOAPport.class);
		log.info("DSS soap port created succesfully!");
		return port;
	}

	public SOAPport getDssPdfPort(){
		log.info("Getting DSS_PDF soap port");
		SOAPport port = this.service.getPort(PsisClientFactory.psisDssPdfPortName, SOAPport.class);
		log.info("DSS_PDF soap port created succesfully!");
		return port;
	}

	private void init(){
		log.info("Starting creating service");	
		log.info("DSS Endpoint: " + this.getConfigurator().getDSSEndpoint().toString());
		log.info("DSSPDF Endpoint: " + this.getConfigurator().getDSSPDFEndpoint().toString());
		this.service = new DigitalSignatureService();
		this.service.addPort(PsisClientFactory.psisDssPortName, "http://schemas.xmlsoap.org/soap/", this.getConfigurator().getDSSEndpoint().toString());
		this.service.addPort(PsisClientFactory.psisDssPdfPortName,"http://schemas.xmlsoap.org/soap/", this.getConfigurator().getDSSPDFEndpoint().toString());
		log.info("Service created succesfully!");
	}
}
