/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.io.IOException;
import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.ws.security.cache.EHCacheReplayCacheFactory;
import org.apache.cxf.ws.security.cache.MemoryReplayCacheFactory;
import org.apache.ws.security.cache.ReplayCache;

public abstract class ReplayCacheFactory {
    private static boolean ehCacheInstalled;

    protected static synchronized boolean isEhCacheInstalled() {
        return ehCacheInstalled;
    }

    public static ReplayCacheFactory newInstance() {
        if (ReplayCacheFactory.isEhCacheInstalled()) {
            return new EHCacheReplayCacheFactory();
        }
        return new MemoryReplayCacheFactory();
    }

    public abstract ReplayCache newReplayCache(String var1, Message var2);

    protected URL getConfigFileURL(Message message) {
        Object o = message.getContextualProperty("ws-security.cache.config.file");
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = message.getExchange().get(Bus.class).getExtension(ResourceManager.class);
            url = rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)o, ReplayCacheFactory.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException e) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    static {
        try {
            Class<?> cacheManagerClass = Class.forName("net.sf.ehcache.CacheManager");
            if (cacheManagerClass != null) {
                ehCacheInstalled = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

