using System;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System.Collections.Generic;

namespace iArxiu.NETGuide
{
    public sealed class UTF8Filter
    {
        private static Dictionary<char, char> translation;

        static UTF8Filter()
        {
            translation = new Dictionary<char, char>();

            /* Conflicts */
            translation.Add('\u2013', '-');
            translation.Add('\u2019', '\'');
            translation.Add('\u201C', '"');
            translation.Add('\u201D', '"');
            translation.Add('\u20AC', '');
            translation.Add('\u2018', '\'');
            translation.Add('\u201B', '\'');
            translation.Add('\u2032', '\'');
            translation.Add('\uFE32', '\'');
            translation.Add('\u2010', '-');
            translation.Add('\u2011', '-');
            translation.Add('\u2012', '-');
            translation.Add('\u2014', '-');
            translation.Add('\u2015', '-');
            translation.Add('\u2043', '-');
            translation.Add('\uFE58', '-');
            translation.Add('\uFE63', '-');
            translation.Add('\uFF0D', '-');
            translation.Add('\uFE57', '!');
            translation.Add('\uFF01', '!');
            translation.Add('\u201F', '"');
            translation.Add('\u2033', '"');
            translation.Add('\u301D', '"');
            translation.Add('\u301E', '"');
            translation.Add('\uFE5F', '#');
            translation.Add('\uFF03', '#');
            translation.Add('\uFE69', '$');
            translation.Add('\uFF04', '$');
            translation.Add('\uFE6A', '%');
            translation.Add('\uFF05', '%');
            translation.Add('\uFE60', '&');
            translation.Add('\uFF06', '&');
            translation.Add('\u207D', '(');
            translation.Add('\u208D', '(');
            translation.Add('\u2768', '(');
            translation.Add('\u276A', '(');
            translation.Add('\uFD3E', '(');
            translation.Add('\uFE59', '(');
            translation.Add('\uFE5D', '(');
            translation.Add('\uFF08', '(');
            translation.Add('\u207E', ')');
            translation.Add('\u208E', ')');
            translation.Add('\u2769', ')');
            translation.Add('\u276B', ')');
            translation.Add('\uFD3F', ')');
            translation.Add('\uFE5A', ')');
            translation.Add('\uFE5E', ')');
            translation.Add('\uFF09', ')');
            translation.Add('\uFE61', '*');
            translation.Add('\uFF0A', '*');
            translation.Add('\u201A', ',');
            translation.Add('\uFE50', ',');
            translation.Add('\uFF0C', ',');
            translation.Add('\u2024', '.');
            translation.Add('\uFE52', '.');
            translation.Add('\uFF0E', '.');
            translation.Add('\uFF0F', '/');
            translation.Add('\uFE30', ':');
            translation.Add('\uFE55', ':');
            translation.Add('\uFF1A', ':');
            translation.Add('\uFE54', ';');
            translation.Add('\uFF1B', ';');
            translation.Add('\uFE56', '?');
            translation.Add('\uFF1F', '?');
            translation.Add('\uFE6B', '@');
            translation.Add('\uFF20', '@');
            translation.Add('\u2772', '[');
            translation.Add('\u3014', '[');
            translation.Add('\uFF3B', '[');
            translation.Add('\uFE68', '\\');
            translation.Add('\uFF3C', '\\');
            translation.Add('\u2773', ']');
            translation.Add('\u3015', ']');
            translation.Add('\uFF3D', ']');
            translation.Add('\u2017', '_');
            translation.Add('\uFF3F', '_');
            translation.Add('\u2774', '{');
            translation.Add('\u29FC', '{');
            translation.Add('\uFE5B', '{');
            translation.Add('\uFF5B', '{');
            translation.Add('\u0964', '|');
            translation.Add('\uFE31', '|');
            translation.Add('\uFE33', '|');
            translation.Add('\u2775', '}');
            translation.Add('\u29FD', '}');
            translation.Add('\uFE5C', '}');
            translation.Add('\uFF5D', '}');
            translation.Add('\u301C', '~');
            translation.Add('\u2039', '<');
            translation.Add('\u2329', '<');
            translation.Add('\u276C', '<');
            translation.Add('\u276E', '<');
            translation.Add('\u2770', '<');
            translation.Add('\u27E8', '<');
            translation.Add('\u27EA', '<');
            translation.Add('\u3008', '<');
            translation.Add('\u300A', '<');
            translation.Add('\u203A', '>');
            translation.Add('\u232A', '>');
            translation.Add('\u276D', '>');
            translation.Add('\u276F', '>');
            translation.Add('\u2771', '>');
            translation.Add('\u27E9', '>');
            translation.Add('\u27EB', '>');
            translation.Add('\u3009', '>');
            translation.Add('\u300B', '>');
            translation.Add('\u30FB', '');
            translation.Add('\uFF65', '');

        }

        public string Execute(string s)
        {
            char[] chars = s.ToCharArray();

            for (int i = 0; i < chars.Length; i++)
            {
                char c = chars[i];

                if (IsUTF8Conflict(c))
                {
                    c = Translate(c);

                    chars[i] = c;
                }
            }

            return new String(chars);
        }

        private bool IsUTF8Conflict(char c)
        {
            return Encoding.UTF8.GetByteCount(new char[] { c }) > 2;
        }

        private char Translate(char c)
        {
            if (!translation.ContainsKey(c))
                throw new ArgumentException(String.Format("Could not translate '{0}' = '{1:X4}'", c, (int)c));

            return translation[c];
        }
    }
}
