using System;
using System.Collections.Generic;
using System.Text;

namespace iArxiu.NETGuide
{
    class TestClient
    {
        static void Main(string[] args)
        {
            string offlineTicket;
            string packageId1, packageId2, packageId3;

            // Ingest offline
            Console.WriteLine("------------------- INGEST OFFLINE ---------------------");
            offlineTicket = Ing_Ingressa_Offline_Mets.doTest();

            // Query last ingest until processed
            do {
                Console.WriteLine("------------ CHECKING INGEST OFFLINE STATUS ------------");
                packageId1 = Ing_Consulta_Estat_Ingres_Offline.doTest(offlineTicket);
            } while (packageId1 == null);

            // Get the URL of last ingest
            Console.WriteLine("------------------- GET URL ---------------------");
            Dis_Consulta_URL.doTest(packageId1);

            // Zip ingest offline
            Console.WriteLine("----------------- ZIP INGEST OFFLINE --------------------");
            offlineTicket = Ing_Ingressa_Offline_Mets_ZIP.doTest();

            // Query last ingest until processed
            do
            {
                Console.WriteLine("------------ CHECKING INGEST OFFLINE STATUS ------------");
                packageId2 = Ing_Consulta_Estat_Ingres_Offline.doTest(offlineTicket);
            } while (packageId2 == null);

            // Compressed Upload ingest
            Console.WriteLine("--------------- COMPRESSED UPLOAD INGEST -------------------");
            Ing_Ingressa_Mets_Upload_Compressed.doTest();

            // (Uncompressed) Upload ingest
            Console.WriteLine("-------------------- UPLOAD INGEST -------------------------");
            packageId3 = Ing_Ingressa_Mets_Upload.doTest();

            // Dissemination
            Console.WriteLine("-------------------- BINARI DOWNLOAD -------------------------");
            Dis_Consulta_Binary.doTest(packageId3, "BIN_1.0");

            Console.WriteLine("-------------------- COPIA ORIGINAL  -------------------------");
            Dis_Consulta_CopiaOriginal.doTest(packageId3, "BIN_1.0");

            Console.WriteLine("--------------------   EVIDENCIA     -------------------------");
            Dis_Consulta_Evidencia.doTest(packageId3);

            Console.WriteLine("--------------------     FIND        -------------------------");
            Dis_Consulta_Find.doTest();
            Console.WriteLine("--------------------    FIND_IDS     -------------------------");
            Dis_Consulta_Find_IDs.doTest();

            Console.WriteLine("--------------------   CONSULTA MD   -------------------------");
            Dis_Consulta_MD.doTest(packageId3, "DMD_1");

            Console.WriteLine("--------------------  CONSULTA METS  -------------------------");
            Dis_Consulta_Mets.doTest(packageId3);

            Console.WriteLine("------------------  CONSULTA METS ZIP  -----------------------");
            Dis_Consulta_Mets_ZIP.doTest(packageId3);

            Console.WriteLine("------------------   MIGRATE BINARY    -----------------------");
            Dis_Consulta_Migrate_Binary.doTest(packageId3, "BIN_1.0", "application/pdf", ".pdf");

            // Administration
            Console.WriteLine("------------------   ADM ESBORRA METS  -----------------------");
            Adm_Esborra_METS.doTest(packageId1);
        }
    }
}
