﻿using System;
using System.Collections.Generic;

/*
 * XML
 */
using System.Xml;
using System.Xml.Serialization;

/*
 * WSE 3.0
 */
using Microsoft.Web.Services3;
using Microsoft.Web.Services3.Design;
using Microsoft.Web.Services3.Security;
using Microsoft.Web.Services3.Security.Xml;
using Microsoft.Web.Services3.Security.Tokens;

/*
 * X509 CERTIFICATES
 */
using System.Security.Cryptography.X509Certificates;

namespace iArxiu.NETGuide
{
    public class SignaturePolicyAssertion : SecurityPolicyAssertion
    {
        private X509SecurityToken taToken;

        public X509SecurityToken X509Token
        {
            get { return taToken; }
        }

        public override SoapFilter CreateClientInputFilter(FilterCreationContext context)
        {
            return null;
        }

        public override SoapFilter CreateClientOutputFilter(FilterCreationContext context)
        {
            return new SecuritySignatureFilter(this);
        }

        public override SoapFilter CreateServiceInputFilter(FilterCreationContext context)
        {
            return null;
        }

        public override SoapFilter CreateServiceOutputFilter(FilterCreationContext context)
        {
            return null;
        }

        public override void ReadXml(System.Xml.XmlReader reader, IDictionary<string, Type> extensions)
        {
            bool isEmpty;

            StoreLocation storeLocation = StoreLocation.CurrentUser;
            StoreName storeName = StoreName.My;
            string subjectDN = null;

            isEmpty = reader.IsEmptyElement;
            reader.ReadStartElement("SignaturePolicyAssertion");
            if (!isEmpty)
            {
                if (reader.MoveToContent() == XmlNodeType.Element && reader.Name == "X509TokenProvider")
                {
                    string storeLocationAttribute = reader.GetAttribute("storeLocation");
                    string storeNameAttribute = reader.GetAttribute("storeName");

                    if (storeLocationAttribute != null)
                        storeLocation = (StoreLocation)Enum.Parse(typeof(StoreLocation), storeLocationAttribute, true);

                    if (storeNameAttribute != null)
                        storeName = (StoreName)Enum.Parse(typeof(StoreName), storeNameAttribute, true);

                    subjectDN = reader.GetAttribute("subjectDN");

                    isEmpty = reader.IsEmptyElement;
                    reader.ReadStartElement();
                    if (!isEmpty) reader.ReadEndElement();
                }

                reader.ReadEndElement();
            }

            if (subjectDN == null)
                throw new ArgumentNullException("Missing subjectDN attribute");
            taToken = X509TokenProvider.CreateToken(storeLocation, storeName, subjectDN);
            
        }
    }

    public class SecuritySignatureFilter : SendSecurityFilter
    {
        private X509SecurityToken taToken;

        public SecuritySignatureFilter(SignaturePolicyAssertion policyAssertion)
            : base(policyAssertion.ServiceActor, true)
        {
            taToken = policyAssertion.X509Token;
        }

        public override void SecureMessage(SoapEnvelope envelope, Security security)
        {
            security.Tokens.Add(taToken);

            MessageSignature signature = new MessageSignature(taToken);
            signature.SignatureOptions = SignatureOptions.IncludeSoapBody;

            XmlNode contextHeader = findContextHeader(envelope);
            if (contextHeader != null)
            {
                SignatureReference reference = new SignatureReference("#" + contextHeader.Attributes["Id", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd"].Value);
                reference.AddTransform(new XmlDsigExcC14NTransform());

                signature.AddReference(reference);
            }

            security.Elements.Add(signature);
        }

        private XmlNode findContextHeader(SoapEnvelope envelope)
        {
            foreach (XmlNode child in envelope.Header.ChildNodes)
            {
                if (child != null && child.LocalName == "Context" && child.NamespaceURI == "http://soap.iarxiu/headers")
                {
                    return child;
                }
            }

            return null;
        }
    }
}
