﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Services.Protocols;

namespace iArxiu.NETGuide
{
    public class SamlSoapExtension : SoapExtension
    {
        public override object GetInitializer(LogicalMethodInfo l, SoapExtensionAttribute s)
        { 
            throw new NotImplementedException();
        }
        public override object GetInitializer(Type serviceType)
        {
            return null;
        }
        public override void Initialize(object o)
        { }

        public override void ProcessMessage(SoapMessage message)
        {
            switch (message.Stage)
            {
                case SoapMessageStage.BeforeSerialize:
                    if (message is SoapClientMessage)
                    {
                        SamlHeader samlHeader = new SamlHeader();
                        samlHeader.MustUnderstand = true;

                        AssertionType assertion = CreateAssertion();

                        samlHeader.Assertion = assertion;

                        message.Headers.Add(samlHeader);
                    }
                    break;
            }
        }

        private AssertionType CreateAssertion()
        {
            AssertionType assertion = new AssertionType();
            assertion.ID = "AssertID-"+Guid.NewGuid().ToString();
            assertion.Version = "2.0";
            NameIDType issuerName = new NameIDType();
            issuerName.Value = "iArxiu_JavaGuide";
            assertion.Issuer = issuerName;
            assertion.IssueInstant = DateTime.Now;

            SubjectType subject = new SubjectType();
            SubjectConfirmationType subjectCofirmation = new SubjectConfirmationType();
            subjectCofirmation.Method = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";

            NameIDType subjectName = new NameIDType();
            subjectName.Value = "Username";

            subjectCofirmation.Item = subjectName;

            subject.Items = new Object[] { subjectCofirmation };

            assertion.Subject = subject;

            AttributeStatementType attributeStatement = new AttributeStatementType();

            //IARXIU PREPRODUCCIO
            AttributeType organization = CreateAttribute("urn:iarxiu:2.0:names:organizationAlias", "ens_prova_catcert");
            AttributeType fonds = CreateAttribute("urn:iarxiu:2.0:names:fondsAlias", "fons_prova_catcert");
            AttributeType memberOf = CreateAttribute("urn:iarxiu:2.0:names:member-of", "archivists");

            //IARXIU PRODUCCIO
            //AttributeType organization = CreateAttribute("urn:iarxiu:2.0:names:organizationAlias", "ens_test_catcert");
            //AttributeType fonds = CreateAttribute("urn:iarxiu:2.0:names:fondsAlias", "fons_test_catcert");
            //AttributeType memberOf = CreateAttribute("urn:iarxiu:2.0:names:member-of", "archivists");

            attributeStatement.Items = new object[] { organization, fonds, memberOf };
            assertion.Items = new AttributeStatementType[] { attributeStatement };

            return assertion;
        }

        private AttributeType CreateAttribute(string name, string value)
        {
            AttributeType attribute = new AttributeType();
            attribute.Name = name;
            attribute.AttributeValue = new object[] { value };

            return attribute;
        }


        
    }
}

