using System;
using System.Collections.Generic;
using System.Text;
using iArxiu.Core.Services.Ingest;
using System.Xml;
using System.Xml.Serialization;
using System.IO;

namespace iArxiu.NETGuide
{
    class Ing_MetsUtils
    {
        private static XmlQualifiedName QN_METS = new XmlQualifiedName("mets", "http://www.loc.gov/METS/");

        /**
         * Filtre dels carcters problemtics. Retorna el fitxer temporal on deixa el resultat filtrat
         */
        public static string Filt(String fileName)
        {
            //Amb filtre dels carcters
            string inputMets = fileName;
            string outputMets = System.IO.Path.GetTempFileName();

            UTF8Filter filter = new UTF8Filter();
            string line;

            using (StreamReader input = new StreamReader(inputMets))
            {
                using (StreamWriter output = new StreamWriter(outputMets))
                {
                    while ((line = input.ReadLine()) != null)
                    {
                        line = filter.Execute(line);
                        output.WriteLine(line);
                    }
                }
            }
            return outputMets;
        }
        public static string Filt(Stream stream)
        {
            //Amb filtre dels carcters
            string outputMets = System.IO.Path.GetTempFileName();

            UTF8Filter filter = new UTF8Filter();
            string line;

            using (StreamReader input = new StreamReader(stream))
            {
                using (StreamWriter output = new StreamWriter(outputMets))
                {
                    while ((line = input.ReadLine()) != null)
                    {
                        line = filter.Execute(line);
                        output.WriteLine(line);
                    }
                }
            }
            return outputMets;
        }

        public static mets Read(String fileName)
        {
            mets metsDocument;

            XmlRootAttribute metsRoot = new XmlRootAttribute();
            metsRoot.ElementName = QN_METS.Name;
            metsRoot.Namespace = QN_METS.Namespace;
            metsRoot.IsNullable = true;

            XmlSerializer serializer = new XmlSerializer(typeof(mets), metsRoot);

            //Sense filtre, solament s'haur de tenir aquesta linia 
            //TextReader reader = new StreamReader(fileName);

            //Amb filtre dels carcters
            string inputMets = fileName;
            string outputMets = System.IO.Path.GetTempFileName();

            UTF8Filter filter = new UTF8Filter();
            string line;

            using (StreamReader input = new StreamReader(inputMets))
            {
                using (StreamWriter output = new StreamWriter(outputMets))
                {
                    while ((line = input.ReadLine()) != null)
                    {
                        line = filter.Execute(line);
                        output.WriteLine(line);
                    }
                }
            }
            TextReader reader = new StreamReader(outputMets);
            //Fi del filtre

            metsDocument = (mets)serializer.Deserialize(reader);
            reader.Close();

            return metsDocument;
        }
    
    }

}
