using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Schema;
using System.IO;
using System.Xml;
using iArxiu.Core.Services.Ingest;
using System.Threading;

namespace iArxiu.NETGuide
{
    class Ing_MetsUpload
    {
        public static IngestService proxy = new IngestService();
        static bool valid = true;

        public static string GetUploadTicket()
        {
            string ticket = null;

            GetUploadTicketRequest request = new GetUploadTicketRequest();
            proxy.Url = BasicConfiguration.getCoreSoapEndpoint();
            proxy.SetPolicy("CorePolicy");
            proxy.Timeout = 30000000;

            GetUploadTicketResponse response = proxy.GetUploadTicket(request);
            ticket = response.ticket;
            Console.WriteLine("ID del Tiquet d'Upload : {0}", ticket);
            return ticket;
        }

        public static void CompressedUpload(string uploadTicket, string zipFile)
        {
            HttpMultiPartClient httpClient = new HttpMultiPartClient();
            httpClient.Url = BasicConfiguration.getUploadUrl();

            httpClient.Parts.Add(new HttpFieldPart("ticket", uploadTicket));
            httpClient.Parts.Add(new HttpFieldPart("compressed", "true"));
            httpClient.Parts.Add(new HttpFilePart("compressedUpload.zip", zipFile));

            httpClient.Send();
            Console.WriteLine("Compressed UpLoad realitzat correctament.");
        }

        public static void Upload(string uploadTicket, string metsFilename, string appendsDirectory)
        {

            //Verificar correctesa del mets
            bool isvalid = ValidateXmlUsingXsd2(metsFilename);
            if (isvalid)
            {
                Console.WriteLine("El mets s vlid");
            }
            else
            {
                Console.WriteLine("El mets no s vlid");
            }

            HttpMultiPartClient httpClient = new HttpMultiPartClient();
            httpClient.Url = BasicConfiguration.getUploadUrl();

            httpClient.Parts.Add(new HttpFieldPart("ticket", uploadTicket));
            HttpFilePart metsFilePart = new HttpFilePart("mets", metsFilename);
            metsFilePart.SimpleFilenameAsIsToBeSent = "mets.xml"; // Make sure 'mets.xml' is used
            httpClient.Parts.Add(metsFilePart);

            string[] filePaths = Directory.GetFiles(appendsDirectory);
            int i = 0;

            while (i < filePaths.GetLength(0))
            {
                string filePath = filePaths[i];
                FileInfo fileInfo = new FileInfo(filePath);
                string filePathId = fileInfo.Name;
                httpClient.Parts.Add(new HttpFilePart(filePathId, filePath));
                i++;
            }

            httpClient.Send();
            Console.WriteLine("UpLoad realitzat correctament del mets.xml i dels {0} fitxers adjunts", i);
        }

        private static bool ValidateXmlUsingXsd2(string fitxer)
        {
            StreamReader rd = new StreamReader(fitxer);
            string XmlData = rd.ReadToEnd();
            rd.Close();
            XmlReaderSettings settings = new XmlReaderSettings();
            settings.ValidationType = ValidationType.Schema;
            settings.Schemas.Add(null, "resources/xsd/mets.xsd");
            settings.ValidationFlags = XmlSchemaValidationFlags.ReportValidationWarnings;
            settings.ValidationEventHandler += new ValidationEventHandler(ValidationCallBack);

            StringReader xmlStream = new StringReader(XmlData);
            XmlReader reader = XmlReader.Create(xmlStream, settings);
            while (reader.Read()) ;
            return valid;
        }

        private static void ValidationCallBack(object sender, ValidationEventArgs e)
        {
            if (e.Severity.Equals(XmlSeverityType.Error))
            {
                valid = false;
                Console.WriteLine("Error en la validaci del mets : {0}", e.Message);
            }
        }

        public static string OfflineIngest(string uploadTicket, bool preservation, contentTypeHandlingType contentTypeHandling)
        {
            string offlineTicket = null;

            OfflineUploadIngestRequest request = new OfflineUploadIngestRequest();
            request.preservation = preservation;
            request.contentTypeHandling = contentTypeHandling;
            request.uploadTicket = uploadTicket;
            proxy.Url = BasicConfiguration.getCoreSoapEndpoint();
            proxy.SetPolicy("CorePolicy");
            proxy.Timeout = 30000000;
            offlineTicket = proxy.OfflineUploadIngest(request);
            Console.WriteLine("Offline Ingest realitzat correctament", offlineTicket);
            return offlineTicket;
        }

        public static string WaitOffline(string offlineTicket)
        {
            string packageId = null;
            proxy.Url = BasicConfiguration.getCoreSoapEndpoint();
            proxy.SetPolicy("CorePolicy");
            proxy.Timeout = 30000000;
            offlineIngestInfoType ingestInfo;
            Console.WriteLine("Esperant l'ingres");
            while (true)
            {
                GetOfflineIngestStatusRequest request = new GetOfflineIngestStatusRequest();
                request.Value = offlineTicket;
                request.signatureValidationDetails = false;
                GetOfflineIngestStatusResponse response = proxy.GetOfflineIngestStatus(request);
                ingestInfo = response.offlineIngestInfo;

                //Escriure en un fitxer la response

                String x = Utils.MessageToString(response);
                string fic3 = Utils.getResultFilename("Consulta_Estat_Ingres_Offline_Response.xml");
                System.IO.StreamWriter sw3 = new System.IO.StreamWriter(fic3);
                sw3.WriteLine(x);
                sw3.Close();

                if (ingestInfo.status != offlineIngestInfoTypeStatus.inProcess)
                    break;

                Thread.Sleep(1000);
            }

            switch (ingestInfo.status)
            {
                case offlineIngestInfoTypeStatus.ok:

                    Console.WriteLine("El paquet ja ha estat ingressat. El seu ID s: {0}", ingestInfo.id);

                    if ((ingestInfo.signatureValidationDetail != null) && ((ingestInfo.signatureValidationDetail.preservedSignatures != null) || (ingestInfo.signatureValidationDetail.nonPreservedSignatures != null) || (ingestInfo.signatureValidationDetail.invalidSignatures != null)))
                    {
                        Console.WriteLine("\nInformaci addicional:\n\n");
                        Console.WriteLine("Signatures preservades:\n");
                        int i = 0;

                        while (i < ingestInfo.signatureValidationDetail.preservedSignatures.Length)
                        {
                            Console.WriteLine("Signatura preservada {0}: {1}\n", i + 1, ingestInfo.signatureValidationDetail.preservedSignatures[i]);
                            i++;
                        }
                        Console.WriteLine("\nSignatures vlides no preservades:\n");
                        i = 0;
                        while (i < ingestInfo.signatureValidationDetail.nonPreservedSignatures.Length)
                        {
                            Console.WriteLine("Signatura vlida no preservada {0}: {1}\n", i + 1, ingestInfo.signatureValidationDetail.nonPreservedSignatures[i]);
                            i++;
                        }
                    }
                    else
                    {
                        Console.WriteLine("\nEl paquet no cont cap document signat");
                    }
                    break;

                case offlineIngestInfoTypeStatus.okInvalidSignatures:

                    Console.WriteLine("El paquet ja ha estat ingressat. El seu ID s: {0}", ingestInfo.id);

                    if (ingestInfo.signatureValidationDetail != null)
                    {
                        Console.WriteLine("\nInformaci addicional:\n\n");
                        Console.WriteLine("Signatures preservades:\n");
                        int i = 0;
                        while (i < ingestInfo.signatureValidationDetail.preservedSignatures.Length)
                        {
                            Console.WriteLine("Signatura preservada {0}: {1}\n", i + 1, ingestInfo.signatureValidationDetail.preservedSignatures[i]);
                            i++;
                        }
                        Console.WriteLine("\nSignatures vlides no preservades:\n");
                        i = 0;
                        while (i < ingestInfo.signatureValidationDetail.nonPreservedSignatures.Length)
                        {
                            Console.WriteLine("Signatura vlida no preservada {0}: {1}\n", i + 1, ingestInfo.signatureValidationDetail.nonPreservedSignatures[i]);
                            i++;
                        }
                        Console.WriteLine("\nSignatures no vlides:\n");
                        i = 0;
                        while (i < ingestInfo.signatureValidationDetail.invalidSignatures.Length)
                        {
                            Console.WriteLine("Signatura no vlida {0}: {1}", i + 1, ingestInfo.signatureValidationDetail.invalidSignatures[i].idSignature);
                            Console.WriteLine("Ra de signatura no vlida {0}: {1}\n", i + 1, ingestInfo.signatureValidationDetail.invalidSignatures[i].reason);
                            i++;
                        }
                    }
                    break;

                case offlineIngestInfoTypeStatus.error:
                    throw new ApplicationException(ingestInfo.errorCode);

                case offlineIngestInfoTypeStatus.unknown:
                    throw new ApplicationException("Unknown status");
            }

            packageId = ingestInfo.id;

            return packageId;
        }
    }
}
