﻿using System;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using System.Xml;
using iArxiu.Core.Services;
using System.Collections.Generic;
using System.Xml.Linq;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Linq;
using iArxiu.Core.Services.Ingest;
using ICSharpCode.SharpZipLib.Zip;
using System.Xml.Schema;

namespace iArxiu.NETGuide
{
    class Ing_Ingressa_Offline_Mets_ZIP
    {
        static bool valid = true;

        /**
         * Returns offlineTicket to be used for asking ingest process status
         */
        public static string doTest()
        {
            String path = "resources/201006150906265.zip";

            //Verifiquem la validesa de la estructura del mets
            ZipFile zipFile = new ZipFile(path);
            ZipEntry zipEntry = zipFile.GetEntry("mets.xml");
            Stream inputStream = zipFile.GetInputStream(zipEntry);
           
            //Verificar correctesa del mets
            bool isvalid = ValidateXmlUsingXsd2(inputStream);
            if (isvalid)
            {
                Console.WriteLine("El mets.xml és vàlid");
            }
            else
            {
                Console.WriteLine("El mets.xml no és vàlid");
            }

            inputStream = zipFile.GetInputStream(zipEntry);
            string filtered = Ing_MetsUtils.Filt(inputStream);
          
            zipFile.BeginUpdate();
            zipFile.Delete(zipEntry);
            zipFile.Add(filtered);

            IngestService proxy = new IngestService();
            proxy.Url = BasicConfiguration.getCoreSoapEndpoint();
            proxy.SetPolicy("CorePolicy");
            proxy.Timeout = 30000000;

            FileStream fs = new FileStream(path, FileMode.Open, FileAccess.Read);
            byte[] ImageData = new byte[fs.Length];
            fs.Read(ImageData, 0, System.Convert.ToInt32(fs.Length));
            fs.Close();


            OfflineZipIngestRequest request = new OfflineZipIngestRequest();
            request.preservation = false;
            //request.preservation = true;

            

            //request.contentTypeHandling = contentTypeHandlingType.completeWithIntrospection;
            //request.contentTypeHandling = contentTypeHandlingType.checkAndReject;
            request.contentTypeHandling = contentTypeHandlingType.replaceWithIntrospection;

            request.zipFile = ImageData;
                        
            String id = proxy.OfflineZipIngest(request);
            
            //Escriure en un fitxer la resposta
            Console.WriteLine("ID - per consultar status posteriorment : {0}", id);
            Console.WriteLine("Prem una tecla...");  Console.ReadKey();
            return id;
        }

        private static bool ValidateXmlUsingXsd2(Stream fitxer)
        {
            StreamReader rd = new StreamReader(fitxer);
            string XmlData = rd.ReadToEnd();
            rd.Close();
            XmlReaderSettings settings = new XmlReaderSettings();
            settings.ValidationType = ValidationType.Schema;
            settings.Schemas.Add(null, "resources/xsd/mets.xsd");
            settings.ValidationFlags = XmlSchemaValidationFlags.ReportValidationWarnings;
            settings.ValidationEventHandler += new ValidationEventHandler(ValidationCallBack);

            StringReader xmlStream = new StringReader(XmlData);
            XmlReader reader = XmlReader.Create(xmlStream, settings);
            while (reader.Read()) ;
            return valid;
        }

        private static void ValidationCallBack(object sender, ValidationEventArgs e)
        {
            if (e.Severity.Equals(XmlSeverityType.Error))
            {
                valid = false;
                Console.WriteLine("Error en la validació del mets : {0}", e.Message);
            }
        }
    }
}