﻿using System;
using System.Text;
using System.Xml.Serialization;
using System.IO;
using System.Xml;
using iArxiu.Core.Services;
using System.Collections.Generic;
using System.Xml.Linq;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Linq;
using iArxiu.Core.Services.Ingest;
using System.Xml.Schema;

namespace iArxiu.NETGuide
{

    class Ing_Ingressa_Offline_Mets
    {
        static bool valid = true;

        /**
         * Returns offlineTicket to be used for asking ingest process status
         */
        public static string doTest()
        {
            string fitxer = "resources/INT-2008-6.xml";
            mets metsFile = Ing_MetsUtils.Read(fitxer);

            //Verificar correctesa del mets
            bool isvalid = ValidateXmlUsingXsd2(fitxer);
            if (isvalid)
            {
                Console.WriteLine("El mets {0} és vàlid", fitxer);
            }
            else
            {
                Console.WriteLine("El mets {0} no és vàlid", fitxer);
            }

            IngestService proxy = new IngestService();
            proxy.Url = BasicConfiguration.getCoreSoapEndpoint();
            proxy.SetPolicy("CorePolicy");
            proxy.Timeout = 30000000;

            OfflineIngestRequest request = new OfflineIngestRequest();

            //request.preservation = false;
            request.preservation = true;

            //request.contentTypeHandling = contentTypeHandlingType.completeWithIntrospection;
            //request.contentTypeHandling = contentTypeHandlingType.checkAndReject;
            request.contentTypeHandling = contentTypeHandlingType.replaceWithIntrospection;

            request.mets = metsFile;

            String id = proxy.OfflineIngest(request);
            Console.WriteLine("ID - per consultar status posteriorment: {0}", id);
            Console.WriteLine("Prem una tecla...");  Console.ReadKey();
            return id;
        }

        private static bool ValidateXmlUsingXsd2(string fitxer)
        {
            StreamReader rd = new StreamReader(fitxer);
            string XmlData = rd.ReadToEnd();
            rd.Close();
            XmlReaderSettings settings = new XmlReaderSettings();
            settings.ValidationType = ValidationType.Schema;
            settings.Schemas.Add(null, "resources/xsd/mets.xsd");
            settings.ValidationFlags = XmlSchemaValidationFlags.ReportValidationWarnings;
            settings.ValidationEventHandler += new ValidationEventHandler(ValidationCallBack);

            StringReader xmlStream = new StringReader(XmlData);
            XmlReader reader = XmlReader.Create(xmlStream, settings);
            while (reader.Read()) ;
            return valid;
        }

        private static void ValidationCallBack(object sender, ValidationEventArgs e)
        {
            if (e.Severity.Equals(XmlSeverityType.Error))
            {
                valid = false;
                Console.WriteLine("Error en la validació del mets : {0}", e.Message);
            }
        }
    }
}