﻿using System;
using System.IO;
using System.Threading;
using iArxiu.Core.Services.Ingest;
using System.Xml.Schema;
using System.Xml;
using ICSharpCode.SharpZipLib.Zip;

namespace iArxiu.NETGuide
{
    class Ing_Ingressa_Mets_Upload_Compressed
    {
        static bool valid = true;

        /**
         * Returns package Id
         */
        public static string doTest()
        {
            string packageId = null;
            string uploadTicket = Ing_MetsUpload.GetUploadTicket();

            string zipFile = getZipFile();
            Ing_MetsUpload.CompressedUpload(uploadTicket, zipFile);
            contentTypeHandlingType contentType = contentTypeHandlingType.completeWithIntrospection;

            string offlineTicket = Ing_MetsUpload.OfflineIngest(uploadTicket, false, contentType);
            packageId = Ing_MetsUpload.WaitOffline(offlineTicket);

            //Escriure en un fitxer la resposta
            Console.WriteLine("Ingrés completat. Obtingut packageId {0}", packageId);
            Console.WriteLine("Prem una tecla...");  Console.ReadKey();
            return packageId;
        }

        /**
         * Returns path of Zip File for test. Validates it.
         */
        public static string getZipFile()
        {
            String path = "resources/201006150906265.zip";

            //Verifiquem la validesa de la estructura del mets
            ZipFile zipFile = new ZipFile(path);
            ZipEntry zipEntry = zipFile.GetEntry("mets.xml");
            Stream inputStream = zipFile.GetInputStream(zipEntry);
           
            //Verificar correctesa del mets
            bool isvalid = ValidateXmlUsingXsd2(inputStream);
            if (isvalid)
            {
                Console.WriteLine("El mets.xml és vàlid");
            }
            else
            {
                Console.WriteLine("El mets.xml no és vàlid");
            }

            // Filter to avoid problem with encoding (as in Ing_Ingressa_Offline_Mets_ZIP)
            inputStream = zipFile.GetInputStream(zipEntry);
            string filtered = Ing_MetsUtils.Filt(inputStream);
            zipFile.BeginUpdate();
            zipFile.Delete(zipEntry);
            zipFile.Add(filtered);

            return path;
        }

        private static bool ValidateXmlUsingXsd2(Stream fitxer)
        {
            StreamReader rd = new StreamReader(fitxer);
            string XmlData = rd.ReadToEnd();
            rd.Close();
            XmlReaderSettings settings = new XmlReaderSettings();
            settings.ValidationType = ValidationType.Schema;
            settings.Schemas.Add(null, "resources/xsd/mets.xsd");
            settings.ValidationFlags = XmlSchemaValidationFlags.ReportValidationWarnings;
            settings.ValidationEventHandler += new ValidationEventHandler(ValidationCallBack);

            StringReader xmlStream = new StringReader(XmlData);
            XmlReader reader = XmlReader.Create(xmlStream, settings);
            while (reader.Read()) ;
            return valid;
        }

        private static void ValidationCallBack(object sender, ValidationEventArgs e)
        {
            if (e.Severity.Equals(XmlSeverityType.Error))
            {
                valid = false;
                Console.WriteLine("Error en la validació del mets : {0}", e.Message);
            }
        }
    }
}
