﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Net;

namespace iArxiu.NETGuide
{
    abstract class HttpPart
    {
        public string Name;

        public HttpPart(string name)
        {
            this.Name = name;
        }
    }

    class HttpFieldPart : HttpPart
    {
        public string Value;

        public HttpFieldPart(string name, string value)
            : base(name)
        {
            this.Value = value;
        }
    }

    class HttpFilePart : HttpPart
    {
        public string Filename;
        public string ContentType;
        public string SimpleFilenameAsIsToBeSent;

        public HttpFilePart(string name, string filename)
            : this(name, filename, "application/octet-stream")
        {
        }

        public HttpFilePart(string name, string filename, string contentType)
            : base(name)
        {
            this.Filename = filename;
            this.ContentType = contentType;
            FileInfo fileInfo = new FileInfo(this.Filename);
            this.SimpleFilenameAsIsToBeSent = fileInfo.Name;
        }
    }

    class HttpMultiPartClient
    {
        private string BOUNDARY = Guid.NewGuid().ToString();

        public string Url;

        public List<HttpPart> Parts = new List<HttpPart>();

        public string Send()
        {
            string responseBody = null;

            byte[] postData = GetPostData();

            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(Url);

            request.Method = "POST";
            request.ContentLength = postData.Length;
            request.ContentType = String.Format("multipart/form-data; boundary={0}", BOUNDARY);
            request.Timeout = 3000000;
            Stream requestStream = request.GetRequestStream();
            requestStream.Write(postData, 0, postData.Length);
            requestStream.Flush();

            HttpWebResponse response = (HttpWebResponse)request.GetResponse();

            StreamReader sr = new StreamReader(response.GetResponseStream());
            responseBody = sr.ReadToEnd();
            sr.Close();

            return responseBody;
        }

        private byte[] GetPostData()
        {
            MemoryStream postData = new MemoryStream();

            foreach (HttpPart part in Parts)
            {
                Append(postData, "--{0}\r\n", BOUNDARY);

                if (part is HttpFieldPart)
                {
                    HttpFieldPart httpFieldPart = (HttpFieldPart)part;

                    Append(postData, "Content-Disposition: form-data; name=\"{0}\"\r\n", httpFieldPart.Name);
                    Append(postData, "\r\n");

                    Append(postData, httpFieldPart.Value);
                }
                else
                {
                    HttpFilePart httpFilePart = (HttpFilePart)part;

                    Append(postData, "Content-Disposition: form-data; name=\"{0}\"; filename=\"{1}\"\r\n", httpFilePart.Name, httpFilePart.SimpleFilenameAsIsToBeSent);
                    Append(postData, "Content-Type: {0}\r\n", httpFilePart.ContentType);
                    Append(postData, "Content-Transfer-Encoding: binary\r\n");
                    Append(postData, "\r\n");

                    Append(postData, File.ReadAllBytes(httpFilePart.Filename));
                }

                Append(postData, "\r\n");
            }

            Append(postData, "--{0}--", BOUNDARY);

            return postData.GetBuffer();
        }

        private void Append(MemoryStream buffer, string data)
        {
            byte[] bufferData = Encoding.UTF8.GetBytes(data);
            buffer.Write(bufferData, 0, bufferData.Length);
        }

        private void Append(MemoryStream buffer, string data, params object[] args)
        {
            byte[] bufferData = Encoding.UTF8.GetBytes(String.Format(data, args));
            buffer.Write(bufferData, 0, bufferData.Length);
        }

        private void Append(MemoryStream buffer, byte[] data)
        {
            buffer.Write(data, 0, data.Length);
        }
    }
}
