using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using iArxiu.Core.Services.Dissemination;

namespace iArxiu.NETGuide
{
    class Dis_SearchUtils
    {
        private static XmlQualifiedName QN_METS = new XmlQualifiedName("search", "http://schemas.core.iarxiu.hp.com/indexer");

        public static SearchType Read(String fileName)
        {
            SearchType searchType;

            XmlRootAttribute metsRoot = new XmlRootAttribute();
            metsRoot.ElementName = QN_METS.Name;
            metsRoot.Namespace = QN_METS.Namespace;
            metsRoot.IsNullable = true;

            XmlSerializer serializer = new XmlSerializer(typeof(SearchType), metsRoot);

            TextReader reader = new StreamReader(fileName);
            searchType = (SearchType)serializer.Deserialize(reader);
            reader.Close();

            return searchType;

        }    
    }
}
