using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Net;
using System.Web;

namespace iArxiu.NETGuide
{
    public class Dis_DownloadHelper
    {
        /**
         * Downloads binary and saves to temporary file. Returns its path.
         */
        public static String downloadByTicketToTemporaryFile(string binToken)
        {
            Stream binaryStream = downloadByTicketAsInputStream(binToken);
            string file = dumpToTemporaryFile(binaryStream);
            return file;
        }

        /**
         * Downloads binary and saves to file.
         */
        public static void downloadByTicketToFile(string binToken, string file)
        {
            Stream binaryStream = downloadByTicketAsInputStream(binToken);
            dumpToFile(binaryStream, file);
        }
        
        public static Stream downloadByTicketAsInputStream(string binToken)
        {
            HttpWebRequest httpWReq = (HttpWebRequest)WebRequest.Create(BasicConfiguration.getDownloadUrl());
            string postData = "tokenId=" + HttpUtility.UrlEncode(binToken);
            byte[] data = Encoding.UTF8.GetBytes(postData);

            httpWReq.Method = "POST";
            httpWReq.ContentType = "application/x-www-form-urlencoded";
            httpWReq.ContentLength = data.Length;

            using (Stream stream = httpWReq.GetRequestStream())
            {
                stream.Write(data, 0, data.Length);
            }

            HttpWebResponse response = (HttpWebResponse)httpWReq.GetResponse();

            return response.GetResponseStream();
        }

        /**
         * Saves to a temporary file. Return the name of such file. 
         * Closes input stream
         */
        public static String dumpToTemporaryFile(Stream input)
        {
            string file = System.IO.Path.GetTempFileName();
            dumpToFile(input, file);
            return file;
        }

        public static void dumpToFile(Stream input, string destinationFile)
        {
            using (Stream output = File.OpenWrite(destinationFile))
            {
                CopyStream(input, output);
                output.Close();
            }
            input.Close();
        }

        private static void CopyStream(Stream input, Stream output)
        {
            byte[] buffer = new byte[8 * 1024];
            int len;
            while ((len = input.Read(buffer, 0, buffer.Length)) > 0)
            {
                output.Write(buffer, 0, len);
            }
        }
    }
}
