﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Linq;
using System.Xml.Serialization;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Linq;
using System.IO;
using System.Xml;
using iArxiu.Core.Services.Dissemination;

namespace iArxiu.NETGuide
{
    class Dis_Consulta_Migrate_Binary
    {
        public static void doTest(string packageId, string binaryId, string toFormat, string toExtension)
        {
            DisseminationService disse = new DisseminationService();
            disse.Url = BasicConfiguration.getCoreSoapEndpoint();
            disse.SetPolicy("CorePolicy");
            
			MigrateBinaryRequest request = new MigrateBinaryRequest();
            
            request.packageId = packageId;
            request.binaryId = binaryId;
            request.toFormat = toFormat;

            MigrateBinaryResponse response;
            response = disse.MigrateBinary(request);

            string binTiquet = response.contentDownloadTicket;
            string tmpFile = Utils.getResultFilename("ResultMigrateBinary" + toExtension);
            Dis_DownloadHelper.downloadByTicketToFile(binTiquet, tmpFile);


            //Escriure en un fitxer la resposta
            XmlSerializer serializer = null;
            MemoryStream writer = new MemoryStream();
            serializer = new XmlSerializer(response.GetType());
            serializer.Serialize(writer, response);
            String x = Encoding.UTF8.GetString(writer.GetBuffer(), 0, writer.GetBuffer().Length);
            string fic = Utils.getResultFilename("ResultConsultaMigrateBinary.xml");
            System.IO.StreamWriter sw = new System.IO.StreamWriter(fic);
            sw.WriteLine(x);
            sw.Close();

            Console.WriteLine("La resposta xml s'ha guardat al fitxer {0}", fic);
            Console.WriteLine("Les dades binaries s'han descarregat satisfactoriament al fitxer {0}", tmpFile);
            Console.WriteLine("Prem una tecla...");  Console.ReadKey();
                        
        }

    }

}