﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Linq;
using System.Xml.Serialization;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Linq;
using System.IO;
using System.Xml;
using iArxiu.Core.Services;
using iArxiu.Core.Services.Dissemination;

namespace iArxiu.NETGuide
{
    class Dis_Consulta_MD
    {
        public static void doTest(string packageId, string metadataId)
        {
            DisseminationService disse = new DisseminationService();
            disse.Url = BasicConfiguration.getCoreSoapEndpoint();
            disse.SetPolicy("CorePolicy");

			GetMDRequest request = new GetMDRequest();
            request.packageId = packageId;
            request.metadataId = metadataId;

            XmlElement response;
            response = disse.GetMD(request);

            //Escribir en fichero
            XmlSerializer serializer = null;
            MemoryStream writer = new MemoryStream();
            serializer = new XmlSerializer(response.GetType());
            serializer.Serialize(writer, response);
            String x = Encoding.UTF8.GetString(writer.GetBuffer(), 0, writer.GetBuffer().Length);
            string tmpFile = Utils.getResultFilename("ResultConsultaMD.xml");
            System.IO.StreamWriter sw = new System.IO.StreamWriter(tmpFile);
            sw.WriteLine(x);
            sw.Close();

            Console.WriteLine("Les metadades s'han descarregat satisfactoriament al fitxer {0}", tmpFile);
            Console.WriteLine("Prem una tecla...");  Console.ReadKey();
        }
    }

}