﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml.Linq;
using System.Xml.Serialization;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Linq;
using System.IO;
using System.Xml;
using iArxiu.Core.Services;
using iArxiu.Core.Services.Dissemination;

namespace iArxiu.NETGuide
{
    class Dis_Consulta_Binary
    {
        public static void doTest(string packageId, string binaryId)
        {
            // Preparar client
            DisseminationService disse = new DisseminationService();
            disse.Url = BasicConfiguration.getCoreSoapEndpoint();
            disse.SetPolicy("CorePolicy");

            // Preparar request
            GetBinaryRequest request = new GetBinaryRequest();
            request.packageId = packageId;
            request.binaryId = binaryId;

            // Executar request
            binaryType response;
            response = disse.GetBinary(request);

            // Bolcar resposta a fitxer
            XmlSerializer serializer = null;
            MemoryStream writer = new MemoryStream();
            serializer = new XmlSerializer(response.GetType());
            serializer.Serialize(writer, response);
            String x = Encoding.UTF8.GetString(writer.GetBuffer(), 0, writer.GetBuffer().Length);
            string fic = Utils.getResultFilename("ResultConsultaBinary.xml");
            System.IO.StreamWriter sw = new System.IO.StreamWriter(fic);
            sw.WriteLine(x);
            sw.Close();
            Console.WriteLine("La resposta xml s'han descarregat satisfactoriament a {0}", fic);

            string downloadTicket = response.binDataDownloadTicket;
            String contentType = response.contentType;
            string binTmpFileName = Utils.getResultFilename("ResultConsultaBinary.bin");
            Dis_DownloadHelper.downloadByTicketToFile(downloadTicket, binTmpFileName);
            Console.WriteLine("Les dades binaries s'han descarregat satisfactoriament a {0}", binTmpFileName);
            Console.WriteLine("(contentType: {0})", contentType);

            Console.WriteLine("Prem una tecla...");  Console.ReadKey();

	}

    }

}