package net.catcert.iarxiu.client.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

import com.hp.iarxiu.core.schemas.x20.ingest.ContentTypeHandlingType;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineZipIngestRequestDocument;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineZipIngestResponseDocument;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineZipIngestRequestDocument.OfflineZipIngestRequest;


/**
 * Classe d'exemple de petici d'inserci a iArxiu d'un PIT comprimit dins un fitxer ZIP, en mode offline.
 */
public class OfflineZipIngestTest {

	public static void main(String[] args) throws Exception {
		
		String path = "201006150906265.zip";
		
		// PIT: Paquet d'Informaci de Transferncia
		byte[] zipFile = loadFileData(path);

		// Verifiquem la validesa de la estructura del mets
		ZipFile zipFile1 = new ZipFile("resources/"+path);
		ZipEntry zipEntry = zipFile1.getEntry("mets.xml");
		InputStream inputStream = zipFile1.getInputStream(zipEntry);
		
		try {
			
			// 1. Lookup a factory for the W3C XML Schema language
	        SchemaFactory factory = 
	        SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
	        
	        // 2. Compile the schema. 
	        // Here the schema is loaded from a java.io.File, but you could use 
	        // a java.net.URL or a javax.xml.transform.Source instead.
	        File schemaLocation = new File("resources/xsd/mets.xsd");
	        Schema schema = factory.newSchema(schemaLocation);
	    
	        // 3. Get a validator from the schema.
	        Validator validator = schema.newValidator();
	        
	        // 4. Parse the document you want to check.
	        Source source = new StreamSource(inputStream);
	        
	        // 5. Check the document
            validator.validate(source);
            System.out.println("mets.xml de " + (zipFile1.getName()).substring(10) + " s vlid.");
        }
        catch (SAXException ex) {
            System.err.println("mets.xml de " + (zipFile1.getName()).substring(10) + " no s vlid perqu " + ex.getMessage());
        }catch (IOException ex) {
            System.err.println("mets.xml de " + (zipFile1.getName()).substring(10) + " no s vlid perqu " + ex.getMessage());
        }
		
		// Crrega de l'application context
		ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");

		// Client
		ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
		
		// Petici d'ingrs d'un arxiu zip
		OfflineZipIngestRequestDocument requestDocument = OfflineZipIngestRequestDocument.Factory.newInstance();
		OfflineZipIngestRequest request = requestDocument.addNewOfflineZipIngestRequest();
		
		// Preservaci d'evidncia:
		//		true -> preservaci d'evidncia i de continguts
		//		false -> noms preservaci dels continguts
		request.setPreservation(false);

		// Tipus del document:
		//		replaceWithIntrospection ->  	Si DROID identifica un format i s diferent a l'indicat pel client,
		//							   			aleshores es substitueix pel detectat.
		//		completeWithIntrospection -> 	Si DROID identifica un format i s diferent a l'indicat pel client,
		//   						   			noms s'informa el PREMIS amb les dades obtingudes amb DROID. Quan 
		//   						   			no hi ha coincidncia, es respecten les dades que posa el client.
		//		checkAndReject ->			   Si DROID identifica un format i s diferent a l'indicat pel client,
		//							   aleshores es rebutja el paquet.
		request.setContentTypeHandling(ContentTypeHandlingType.COMPLETE_WITH_INTROSPECTION);
		
		// ZIP
		request.setZipFile(zipFile);

		// Pintem la petici
		Utils.printXmlObject(requestDocument);
		
		// Guardem la petici en un fitxer
		requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\OfflineZipIngestRequest.xml"));
		
		OfflineZipIngestResponseDocument responseDocument = (OfflineZipIngestResponseDocument)proxy.send(requestDocument);
		
		// Pintem la resposta
		Utils.printXmlObject(responseDocument);
		
		// Guardem la resposta en un fitxer
		responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\OfflineZipIngestResponse.xml"));
		
	}

	/**
	 * Crrega de les dades d'un fitxer.
	 * @param zipFilePath path del fitxer relatiu al classpath
	 * @return byte[] del fitxer
	 * @throws Exception
	 */
	private static byte[] loadFileData(String filePath) throws Exception {
		return Utils.getBytesFromFile(filePath);
	}

}
