package net.catcert.iarxiu.client.test;

import java.io.File;
import java.io.InputStream;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.MigrateBinaryRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.MigrateBinaryRequestDocument.MigrateBinaryRequest;
import com.hp.iarxiu.core.schemas.x20.dissemination.MigrateBinaryResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.MigrateBinaryResponseDocument.MigrateBinaryResponse;


/**
 * Classe d'exemple de petici de migraci del format d'un binari prviament carregat a iArxiu.
 */
public class MigrateBinaryTest {

	public static void main(String[] args) throws Exception {

		// Crrega de l'application context
		ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");

		// Client
		ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
		String downloadUrl = (String) context.getBean("downloadByTicketUrl");

		// Petici de migraci de binari
		MigrateBinaryRequestDocument requestDocument = MigrateBinaryRequestDocument.Factory.newInstance();
		MigrateBinaryRequest request = requestDocument.addNewMigrateBinaryRequest();
		
		// Identificador del paquet
		request.setPackageId("catcert:localhost:20130626-140010924:2873");
		
		// Identificador del binari
		request.setBinaryId("BIN_1.0");
		
		// Incloure binaris
		request.setToFormat("application/pdf");

		// Pintem la petici
		Utils.printXmlObject(requestDocument);
		
		// Guardem la petici en un fitxer
		requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\MigrateBinaryRequest.xml"));
		
		// Enviament de la petici
		MigrateBinaryResponseDocument responseDocument = (MigrateBinaryResponseDocument)proxy.send(requestDocument);
		
		// Pintem la resposta
		Utils.printXmlObject(responseDocument);
		
		// Guardem la resposta en un fitxer
		responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\MigrateBinaryResponse.xml"));
		
		MigrateBinaryResponse response = responseDocument.getMigrateBinaryResponse();
		String binToken = response.getContentDownloadTicket();
		InputStream binData = Utils.downloadByTicketAsInputStream(binToken, downloadUrl);
		Utils.writeToFile(System.getProperty("user.dir")+"\\samples\\MigratedDocument.pdf", binData);
	}

}
