package net.catcert.iarxiu.client.test;

import java.io.File;
import java.io.InputStream;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.GetZipPackageRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetZipPackageResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetZipPackageRequestDocument.GetZipPackageRequest;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetZipPackageResponseDocument.GetZipPackageResponse;


/**
 * Classe d'exemple de petici de recuperaci d'un paquet a iArxiu. El format en qu es recupera s un fitxer comprimit zip.
 */
public class GetZipPackageRequestTest {

	public static void main(String[] args) {
		
		try{
		
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
			
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			String downloadUrl = (String) context.getBean("downloadByTicketUrl");
			
			// Petici de recuperaci de paquet dins un fitxer zip
			GetZipPackageRequestDocument requestDocument = GetZipPackageRequestDocument.Factory.newInstance();
			GetZipPackageRequest request = requestDocument.addNewGetZipPackageRequest();
			
			// Identificador del paquet
			request.setPackageId("catcert:localhost:20130626-140010924:2873");
			
			// Incloure metadades d'acord a l'esquema Dublin Core
			request.setIncludeDC(true);
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			
			//Guardem la petici en un fitxer
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetZipPackageRequest.xml"));
			
			// Enviament de la petici
			GetZipPackageResponseDocument responseDocument = (GetZipPackageResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetZipPackageResponse.xml"));
		
			//gravem les dades binries en un fitxer
			GetZipPackageResponse response = responseDocument.getGetZipPackageResponse(); 
			String binToken = response.getPackageDownloadTicket();
			InputStream binData = Utils.downloadByTicketAsInputStream(binToken, downloadUrl);
			Utils.writeToFile(System.getProperty("user.dir")+"\\samples\\ZipPackage.zip", binData);

		}catch(Exception e){
			System.out.println(e.getMessage());
		}
		
	}
	
}
