package net.catcert.iarxiu.client.test;

import java.io.File;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.GetMDRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetMDResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetMDRequestDocument.GetMDRequest;


/**
 * Classe d'exemple de petici de recuperaci d'un determinat vocabulari de 
 * metadades que forma part d'un paquet a iArxiu.
 */
public class GetMDRequestTest {

	public static void main(String[] args) throws Exception {
		
		try{
		
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
	
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			
			// Petici de cerca de metadades
			GetMDRequestDocument requestDocument = GetMDRequestDocument.Factory.newInstance();
			GetMDRequest request = requestDocument.addNewGetMDRequest();
			
			// Identificador del paquet
			request.setPackageId("catcert:localhost:20130626-140010924:2873");
			
			// Identificador de les metadades
			request.setMetadataId("DMD_1");
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			
			// Guardem la petici en un fitxer
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetMDRequest.xml"));
			
			// Enviament de la petici
			GetMDResponseDocument responseDocument = (GetMDResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetMDResponse.xml"));
			
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
		
	}
	
}
