package net.catcert.iarxiu.client.test;

import java.io.File;
import java.io.InputStream;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.BinaryType;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetBinaryRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetBinaryRequestDocument.GetBinaryRequest;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetBinaryResponseDocument;


/**
 * Classe d'exemple de petici de recuperaci d'un determinat binari que 
 * forma part d'un paquet a iArxiu.
 */
public class GetBinaryRequestTest {

	public static void main(String[] args) throws Exception {
		
		try{
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
	
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			String downloadUrl = (String) context.getBean("downloadByTicketUrl");
			
			// Petici de cerca de binaris
			GetBinaryRequestDocument requestDocument = GetBinaryRequestDocument.Factory.newInstance();
			GetBinaryRequest request = requestDocument.addNewGetBinaryRequest();
			
			// Identificador del paquet
			request.setPackageId("catcert:localhost:20130626-140010924:2873");
			
			// Identificador del binari
			request.setBinaryId("BIN_1.0");
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			
			// Guardem la petici en un fitxer
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetBinaryRequest.xml"));
			
			// Enviament de la petici
			GetBinaryResponseDocument responseDocument = (GetBinaryResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetBinaryResponse.xml"));
			
			// Gravem les dades binries en un fitxer
			BinaryType bin = responseDocument.getGetBinaryResponse();
			String binToken = bin.getBinDataDownloadTicket();
			InputStream binData = Utils.downloadByTicketAsInputStream(binToken, downloadUrl);

			System.out.println(bin.getContentType());
			Utils.writeToFile(System.getProperty("user.dir")+"\\samples\\binData.temp", binData);
		
		}catch(Exception e){
			e.printStackTrace();
		}
		
	}
	
}
