package net.catcert.iarxiu.client.test;

import java.io.File;
import java.io.InputStream;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.GetAuthenticCopyRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetAuthenticCopyResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetAuthenticCopyRequestDocument.GetAuthenticCopyRequest;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetAuthenticCopyResponseDocument.GetAuthenticCopyResponse;


/**
 * Classe d'exemple de petici de generaci d'una cpia autntica 
 * d'un determinat binari d'un paquet a iArxiu.
 * 
 * En cas que intentem accedir a un paquet sobre el qual no tenim permisos 
 * ens ho indicar.
 */
public class GetAuthenticCopyRequestTest {

	public static void main(String[] args) throws Exception {
		
		try{
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
	
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			String downloadUrl = (String) context.getBean("downloadByTicketUrl");
			
			// Petici de cpia autntica de binaris
			GetAuthenticCopyRequestDocument requestDocument = GetAuthenticCopyRequestDocument.Factory.newInstance();
			GetAuthenticCopyRequest request = requestDocument.addNewGetAuthenticCopyRequest();
			
			// Identificador del paquet
			request.setPackageId("catcert:localhost:20130626-140010924:2873");
			
			// Identificador del binari
			request.setBinaryId("BIN_1.0");
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			
			// Guardem la petici en un fitxer
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetAuthenticCopyRequest.xml"));
			
			// Enviament de la petici
			GetAuthenticCopyResponseDocument responseDocument = (GetAuthenticCopyResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetAuthenticCopyResponse.xml"));
			
			// Gravem les dades binries en un fitxer
			GetAuthenticCopyResponse response = responseDocument.getGetAuthenticCopyResponse();;
			String binToken = response.getContentDownloadTicket();
			InputStream binData = Utils.downloadByTicketAsInputStream(binToken, downloadUrl);
			
			//System.out.println(new String(binData));
			Utils.writeToFile(System.getProperty("user.dir")+"\\samples\\authenticCopy.pdf", binData);
		
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
	}
	
}
