package net.catcert.iarxiu.client.test.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;


public class Utils {
	

	/**
	 * Prints an XMLObject.
	 * @param xmlObj XMLObject to print
	 * @throws IOException 
	 */
	public static void printXmlObject(XmlObject xmlObj) {	
		
		XmlOptions xmlOptions = new XmlOptions();
		xmlOptions.setSavePrettyPrint();
		xmlOptions.setSaveOuter();
		xmlOptions.setCharacterEncoding("ISO-8859-1");
		
		BufferedOutputStream bos = null;
		InputStream inputStream = null;
		
		try {
			bos = new BufferedOutputStream(System.out);
			int read = 0;
			byte[] bytes = new byte[10000];
			inputStream = xmlObj.newInputStream(xmlOptions);
			while ((read = inputStream.read(bytes)) != -1) {
				bos.write(bytes, 0, read);
				bos.flush();
			}
			bos.write(System.getProperty("line.separator").getBytes());
			bos.flush();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			try {
				inputStream.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	
	/** 
	 * Returns the contents of the file in a byte array.
	 */
    public static byte[] getBytesFromFile(String path) throws IOException {
    	
    	InputStream is = ClassLoader.getSystemResourceAsStream(path);
        byte[] bytes = getBytes(is);
        is.close();

        return bytes;
    }
    
    
    /**
     * Gets a byte array from an InputStream.
     * @param is InputStream
     * @return byte[]
     * @throws IOException
     */
    public static byte[] getBytes(InputStream is) throws IOException {
    
    	ByteArrayOutputStream baos = new ByteArrayOutputStream();
    	
    	int bytee;
    	while (-1!=(bytee=is.read()))
    	{
    	   baos.write(bytee);
    	}
    	baos.close();
    	byte[] bytes = baos.toByteArray();

        is.close();
        return bytes;
    }
	
    
    public static void writeToFile(String path, byte[] data) throws IOException{
    	File fOut = new File(path);
		FileOutputStream fos = new FileOutputStream(fOut);
		fos.write(data);
		fos.close();
    }

    
    public static void writeToFile(String path, InputStream is) throws IOException{
    	System.out.println("Deixant dades a "+path);
    	File fOut = new File(path);
		FileOutputStream fos = new FileOutputStream(fOut);
		BufferedOutputStream bos = new BufferedOutputStream(fos);
		try {
			byte[] buffer = new byte[64000];
			int cnt;
			while ((cnt=is.read(buffer)) != -1) {
				bos.write(buffer, 0, cnt);
			}
		} finally {
			is.close();
			bos.close();
		}
    }

	public static InputStream downloadByTicketAsInputStream(String binToken, String downloadUrl) throws Exception {
		System.out.println("Descarregant dades del servidor...");
		PostMethod postMethod = new PostMethod(downloadUrl);
		postMethod.addParameter("tokenId", binToken);
		
		HttpClient httpClient = new HttpClient();
		int status = httpClient.executeMethod(postMethod);
		if (status != HttpStatus.SC_OK) {
        	throw new Exception(HttpStatus.getStatusText(status)+" ["+postMethod.getStatusLine()+"]");
		}
		InputStream response = postMethod.getResponseBodyAsStream();
		return response;
	}

    private static final int DEFAULT_BUFFER_SIZE = 1024 * 4;
    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[DEFAULT_BUFFER_SIZE];
        long count = 0;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }
	
}