package net.catcert.iarxiu.client.test;

import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsDocument.Mets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.xml.sax.SAXException;

import com.hp.iarxiu.core.schemas.x20.ingest.ContentTypeHandlingType;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineIngestRequestDocument;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineIngestResponseDocument;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineIngestRequestDocument.OfflineIngestRequest;


/**
 * Classe d'exemple de petici d'inserci d'un PIT a iArxiu, en mode offline.
 */
public class OfflineIngestTest {

	public static void main(String[] args) throws Exception {
		String path = "INT-2008-6.xml";
		
		//Verifiquem la validesa de la estructura del mets
		File sourceLocation = new File("resources/"+path);
		try {
			
			// 1. Lookup a factory for the W3C XML Schema language
	        SchemaFactory factory = 
	        SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
	        
	        // 2. Compile the schema. 
	        // Here the schema is loaded from a java.io.File, but you could use 
	        // a java.net.URL or a javax.xml.transform.Source instead.
	        File schemaLocation = new File("resources/xsd/mets.xsd");
	        Schema schema = factory.newSchema(schemaLocation);
	    
	        // 3. Get a validator from the schema.
	        Validator validator = schema.newValidator();
	        
	        // 4. Parse the document you want to check.
	        Source source = new StreamSource(sourceLocation);
	        
	        // 5. Check the document
            validator.validate(source);
            System.out.println(sourceLocation.toString().substring(10) + " s vlid.");
        }
        catch (SAXException ex) {
            System.err.println(sourceLocation.toString().substring(10) + " no s vlid perqu " + ex.getMessage());
        }catch (IOException ex) {
            System.err.println(sourceLocation.toString().substring(10) + " no s vlid perqu " + ex.getMessage());
        }
		
		// PIT: Paquet d'Informaci de Transferncia
		Mets mets = loadMets(path);

		// Crrega de l'application context
		ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");

		// Client
		ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");

		// Petici d'ingrs
		OfflineIngestRequestDocument requestDocument = OfflineIngestRequestDocument.Factory.newInstance();
		OfflineIngestRequest request = requestDocument.addNewOfflineIngestRequest();
		
		// Preservaci d'evidncia:
		// 		true -> preservaci d'evidncia i de continguts
		// 		false -> noms preservaci dels continguts
		request.setPreservation(true);

		// Tipus de detecci del contingut
		//		replaceWithIntrospection ->  	Si DROID identifica un format i s diferent a l'indicat pel client,
		//							   			aleshores es substitueix pel detectat.
		//		completeWithIntrospection -> 	Si DROID identifica un format i s diferent a l'indicat pel client,
		//   						   			noms s'informa el PREMIS amb les dades obtingudes amb DROID. Quan 
		//   						   			no hi ha coincidncia, es respecten les dades que posa el client.
		//		checkAndReject ->			   	Si DROID identifica un format i s diferent a l'indicat pel client,
		//							  			 aleshores es rebutja el paquet.
		request.setContentTypeHandling(ContentTypeHandlingType.COMPLETE_WITH_INTROSPECTION);
		
		//PIT
		request.setMets(mets);

		// Pintem la petici
		Utils.printXmlObject(requestDocument);
		
		// Guardem la petici en un fitxer
		requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\OfflineIngestRequest.xml"));
		
		// Enviament de la petici
		OfflineIngestResponseDocument responseDocument = (OfflineIngestResponseDocument)proxy.send(requestDocument);
		
		// Pintem la resposta
		Utils.printXmlObject(responseDocument);
		
		// Guardem la resposta en un fitxer
		responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\OfflineIngestResponse.xml"));
		
	}

	/**
	 * Crrega del METS.
	 * @param metsName path del METS relatiu al classpath
	 * @return METS
	 * @throws Exception
	 */
	private static Mets loadMets(String metsName) throws Exception {
		InputStream is = ClassLoader.getSystemResourceAsStream(metsName);
		return MetsDocument.Factory.parse(is).getMets();
	}

}
