package net.catcert.iarxiu.client.test;

import java.io.File;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.GetPackageUrlRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetPackageUrlResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetPackageUrlRequestDocument.GetPackageUrlRequest;


/**
 * Classe d'exemple d'obtenci d'URL per a consulta detallada d'un paquet
 */
public class GetPackageUrlRequestTest {

	public static void main(String[] args) {
		
		try {
		
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
			
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			
			// Petici de recuperaci de paquet
			GetPackageUrlRequestDocument requestDocument = GetPackageUrlRequestDocument.Factory.newInstance();
			GetPackageUrlRequest request = requestDocument.addNewGetPackageUrlRequest();
			
			// Identificador del paquet
			request.setPackageId("catcert:localhost:20140611-13353598:9908");
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			
			// Guardem la petici en un fitxer
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetPackageUrlRequest.xml"));
			
			// Enviament de la petici
			GetPackageUrlResponseDocument responseDocument = (GetPackageUrlResponseDocument)proxy.send(requestDocument);
			
			// Obtenim la url i la mostrem a la consola
			String urlViewer = responseDocument.getGetPackageUrlResponse().getPackageUrl();
			System.out.println("\n" + "URL: " + urlViewer + "\n");
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetPackageUrlResponse.xml"));
			
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
	
}
