package net.catcert.iarxiu.client.test;

import java.io.File;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.GetPackageRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetPackageResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetPackageRequestDocument.GetPackageRequest;


/**
 * Classe d'exemple de petici de recuperaci d'un paquet a iArxiu. El format en qu es recupera s METS.
 */
public class GetPackageRequestTest {

	public static void main(String[] args) {
		
		try{
		
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
			
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			
			// Petici de recuperaci de paquet
			GetPackageRequestDocument requestDocument = GetPackageRequestDocument.Factory.newInstance();
			GetPackageRequest request = requestDocument.addNewGetPackageRequest();
			
			// Iidentificador del paquet
			request.setPackageId("catcert:localhost:20130626-140010924:2873");
			
			// Incloure metadades d'acord a l'esquema Dublin Core
			request.setIncludeDC(true);
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			
			// Guardem la petici en un fitxer
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetPackageRequest_withoutBinaries.xml"));
			
			// Enviament de la petici
			GetPackageResponseDocument responseDocument = (GetPackageResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetPackageResponse_withoutBinaries.xml"));
			
		}catch(Exception e){
			e.printStackTrace();
		}
		
	}
	
}
