package net.catcert.iarxiu.client.test;

import java.io.File;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.ingest.GetOfflineIngestStatusRequestDocument;
import com.hp.iarxiu.core.schemas.x20.ingest.GetOfflineIngestStatusResponseDocument;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineIngestInfoType;
import com.hp.iarxiu.core.schemas.x20.ingest.GetOfflineIngestStatusRequestDocument.GetOfflineIngestStatusRequest;
import com.hp.iarxiu.core.schemas.x20.ingest.OfflineIngestInfoType.Status.Enum;


/**
 * Classe d'exemple de petici de consulta de l'estat d'un ingrs fet en mode offline.
 * Es preguntant per l'estat de l'ingrs mentres aquest no ha acabat. 
 */
public class GetOfflineIngestStatusTest {

	public static void main(String[] args) throws Exception {
		
		// identificador del ticket
		String ticketId = "1542604";
				
		// crrega de l'application context
		ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");

		// client
		ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");

		// petici d'ingrs
		GetOfflineIngestStatusRequestDocument requestDocument = GetOfflineIngestStatusRequestDocument.Factory.newInstance();
		GetOfflineIngestStatusRequest getOfflineIngestStatusRequest = requestDocument.addNewGetOfflineIngestStatusRequest();
		getOfflineIngestStatusRequest.setStringValue(ticketId);
		getOfflineIngestStatusRequest.setSignatureValidationDetails(true);
		requestDocument.setGetOfflineIngestStatusRequest(getOfflineIngestStatusRequest);

		// pintem la petici
		Utils.printXmlObject(requestDocument);
		// guardem la petici en un fitxer
		// requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetOfflineIngestStatusRequest.xml"));
		
		// informaci de l'ingrs offline
		OfflineIngestInfoType ingestInfo = null;
		
		// bucle mentre l'estat s 'en procs'
		while(true) {
		
			//enviament de la petici
			GetOfflineIngestStatusResponseDocument responseDocument = (GetOfflineIngestStatusResponseDocument)proxy.send(requestDocument);
			
			//pintem la resposta
			Utils.printXmlObject(responseDocument);
			//guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetOfflineIngestStatusResponse.xml"));
			
			//informaci
			ingestInfo = responseDocument.getGetOfflineIngestStatusResponse().getOfflineIngestInfo();
			
			// estat
			Enum status = ingestInfo.getStatus();
			
			// sortir quan l'estat ja no sigui en procs
			if (!status.equals(OfflineIngestInfoType.Status.IN_PROCESS))
				break;
	
			// esperem un segon
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e) {
				throw new RuntimeException("Error in sleep", e);
			}
			
			// estats d'error
			if (status.equals(OfflineIngestInfoType.Status.ERROR))
				throw new RuntimeException("Offline error: " + ingestInfo.getErrorCode());
			if (status.equals(OfflineIngestInfoType.Status.UNKNOWN))
				throw new RuntimeException("Unknown offline error: " + ingestInfo.getErrorCode());

		}

		// identificador del paquet obtingut a partir de la informaci d'estat de l'ingrs
		String packageId = ingestInfo.getId();
		System.out.println("\n Tiquet: "+packageId);
		
	}

}
