package net.catcert.iarxiu.client.test;

import java.io.File;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.GetEvidenceReportRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetEvidenceReportResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetEvidenceReportRequestDocument.GetEvidenceReportRequest;
import com.hp.iarxiu.core.schemas.x20.dissemination.GetEvidenceReportResponseDocument.GetEvidenceReportResponse;


/**
 * Classe d'exemple de sollicitud de l'informe d'evidncies d'un paquet a iArxiu.
 */
public class GetEvidenceReportRequestTest {

	public static void main(String[] args) throws Exception {
		
		try{
		
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
	
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			
			// Petici de generaci de l'informe d'evidncies
			GetEvidenceReportRequestDocument requestDocument = GetEvidenceReportRequestDocument.Factory.newInstance();
			GetEvidenceReportRequest request = requestDocument.addNewGetEvidenceReportRequest();
			
			// Identificador del paquet
			request.setPackageId("catcert:localhost:20130626-140010924:2873");
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			
			// Guardem la petici en un fitxer
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetEvidenceReportRequest.xml"));
			
			// Enviament de la petici
			GetEvidenceReportResponseDocument responseDocument = (GetEvidenceReportResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\GetEvidenceReportResponse.xml"));
			
			//gravem les dades binries de l'informe en un fitxer PDF
			GetEvidenceReportResponse response = responseDocument.getGetEvidenceReportResponse();
			byte[] binData = response.getReport();
			Utils.writeToFile(System.getProperty("user.dir")+"\\samples\\EvidenceReport.pdf", binData);
			
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
		
	}
	
}
