package net.catcert.iarxiu.client.test;

import java.io.File;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.FindRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.FindResponseDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.FindRequestDocument.FindRequest;
import com.hp.iarxiu.core.schemas.x20.indexer.SearchType;


/**
 * Classe d'exemple de cerca de paquets a iArxiu que compleixen certs criteris 
 * de metadades.s semblant a FindIDRequest per retorna molta ms informaci 
 * de cada paquet. El nombre de resultats es pot limitar amb el parmetre 
 * maxSearchResults de la request. * 
 */
public class FindRequestTest {

	public static void main(String[] args) {
		
		try{
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
			
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			
			// Petici de cerca de paquet
			FindRequestDocument requestDocument = FindRequestDocument.Factory.newInstance();
			FindRequest request = requestDocument.addNewFindRequest();
			
			// Fitxer XML que cont els criteris de cerca
			File searchFile = new File(System.getProperty("user.dir")+"\\src\\net\\catcert\\iarxiu\\client\\test\\basicSearchSample.xml");
			
			// Cerca
			SearchType search = request.addNewSearch();
			search.set(SearchType.Factory.parse(searchFile));
			
			// Nmero mxim de resultats a presentar
			request.setMaxSearchResults(10);
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\FindRequest.xml"));
			
			// Enviament de la petici
			FindResponseDocument responseDocument = (FindResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\FindResponse.xml"));
			
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
	}
}
