package net.catcert.iarxiu.client.test;

import java.io.File;

import net.catcert.iarxiu.client.proxy.ProxyClient;
import net.catcert.iarxiu.client.test.utils.Utils;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import com.hp.iarxiu.core.schemas.x20.dissemination.FindIDsRequestDocument;
import com.hp.iarxiu.core.schemas.x20.dissemination.FindIDsRequestDocument.FindIDsRequest;
import com.hp.iarxiu.core.schemas.x20.dissemination.FindIDsResponseDocument;
import com.hp.iarxiu.core.schemas.x20.indexer.SearchType;


/**
 * Classe d'exemple de cerca de paquets a iArxiu que compleixen certs criteris 
 * de metadades. Els criteris de cerca surten d'un fitxer xml. 
 * 
 * Nota: s possible que la resposta sigui buida si no es troba cap paquet 
 * que compleixi els criteris de cerca.
 */
public class FindIDsRequestTest {

	public static void main(String[] args) {
		
		try{
			
			// Crrega de l'application context
			ApplicationContext context = new ClassPathXmlApplicationContext("applicationContext.xml");
			
			// Client
			ProxyClient proxy = (ProxyClient) context.getBean("proxyClient");
			
			// Petici de cerca de paquet
			FindIDsRequestDocument requestDocument = FindIDsRequestDocument.Factory.newInstance();
			FindIDsRequest request = requestDocument.addNewFindIDsRequest();
			
			// Fitxer XML que cont els criteris de cerca
			File searchFile = new File(System.getProperty("user.dir")+"\\src\\net\\catcert\\iarxiu\\client\\test\\basicSearchSample.xml");
			
			// Cerca
			SearchType search = request.addNewSearch();
			search.set(SearchType.Factory.parse(searchFile));
			
			// Pintem la petici
			Utils.printXmlObject(requestDocument);
			requestDocument.save(new File(System.getProperty("user.dir")+"\\samples\\FindIDsRequest.xml"));
			
			// Enviament de la petici
			FindIDsResponseDocument responseDocument = (FindIDsResponseDocument)proxy.send(requestDocument);
			
			// Pintem la resposta
			Utils.printXmlObject(responseDocument);
			
			// Guardem la resposta en un fitxer
			responseDocument.save(new File(System.getProperty("user.dir")+"\\samples\\FindIdsResponse.xml"));
			
		}catch(Exception e){
			System.out.println(e.getMessage());
		}
		
	}

}
