Attribute VB_Name = "ValidacioSignaturaCMS"
Public Sub ValidacioSignaturaCMS()
        
    'Utilitats
    Set Utils = New PSISClient.Utils
    
    'Inicialitzaci del client
    Dim proxy As New PSISClient.digitalSignatureService
    proxy.url = "http://psisbeta.catcert.net/psis/catcert-test/dss"
    
    'Creaci de l'element amb la signatura CMS a verificar
    Dim signature As New PSISClient.Base64Signature
    signature.Type = "urn:ietf:rfc:3852"
    signature.Value = Utils.Base64File("c:/psis/cms-signature.dat")
    
    Dim sign As New PSISClient.SignatureObjectType
    Set sign.Item = signature
    
    'Documents a enviar
    Dim data As New PSISClient.Base64Data
    data.Value = Utils.Base64File("c:/psis/cms-doc.dat")

    Dim docType(1) As PSISClient.DocumentType
    Set docType(0) = New PSISClient.DocumentType
    Set docType(0).Item = data
    
    Dim clearText As New PSISClient.InputDocuments
    clearText.Items = docType
    
    'Creaci de l'element amb els parmetres opcionals a consultar
    Dim optInputs As PSISClient.OptionalInputs
    Set optInputs = New PSISClient.OptionalInputs
    
    Dim objects(1) As Object
    Dim type7(1) As Long
    
    Set objects(0) = New ObjectType
    type7(0) = PSISClient.ItemsChoiceType7_ReturnProcessingDetails
    
    optInputs.Items = objects
    optInputs.ItemsElementName = type7
        
    'Creaci del missatge DSS
    Dim request As New PSISClient.VerifyRequest
    Set request.SignatureObject = sign
    Set request.InputDocuments = clearText
    Set request.OptionalInputs = optInputs
    
    'Visualitzaci de la petici
    Debug.Print Utils.MessageToString(request)
    
    'Execuci del servei
    Dim response As PSISClient.VerifyResponse
    Set response = proxy.verify(request)
    
    'Visualitzaci de la resposta
    Debug.Print Utils.MessageToString(response)
    
End Sub
