Attribute VB_Name = "ValidacioSegellDeTemps"
Public Sub ValidacioSegellDeTemps()
    
    'Utilitats
    Set Utils = New PSISClient.Utils

    'Inicialitzaci del client
    Dim proxy As New PSISClient.digitalSignatureService
    proxy.url = "http://psisbeta.catcert.net/psis/catcert-test/dss"

    'Composici del missatge

    'Creaci de l'element amb un document
    Dim method As New DigestMethodType
    method.Algorithm = "http://www.w3.org/2000/09/xmldsig#sha1"

    Dim document(1) As DocumentHash
    Set document(0) = New DocumentHash
    document(0).ID = "Doc1"
    document(0).digestMethod = method
    document(0).DigestValue = Utils.Base64File("c:/psis/timestamp-digest1.dat")
    
    'Creaci de l'element amb els documents a verificar
    Dim documents As New InputDocuments
    documents.Items = document
    
    ' Creaci de l'element amb el segell de temps
    Dim signatureType As New SignatureObjectType
    signatureType.Any = Utils.XMLFile("c:/psis/timestamp-xml.dat")
    
    'Creaci de l'element amb els parmetres opcionals a consultar
    Dim optInputs As New OptionalInputs
            
    Dim types7(1) As Long
    types7(0) = ItemsChoiceType7.ItemsChoiceType7_ReturnProcessingDetails
    
    Dim objInputs(1)
    Set objInputs(0) = New ObjectType

    optInputs.Items = objInputs
    optInputs.ItemsElementName = types7

    'Creaci del missatge DSS
    Dim request As New PSISClient.VerifyRequest
    request.SignatureObject = signatureType
    request.OptionalInputs = optInputs
    request.InputDocuments = documents

    'Visualitzaci de la petici
    Debug.Print Utils.MessageToString(request)
    
    'Execuci del servei
    Dim response As PSISClient.VerifyResponse
    Set response = proxy.verify(request)
    
    'visualitzaci de la resposta
    Debug.Print Utils.MessageToString(response)
    
End Sub





