Attribute VB_Name = "CreacioSegellTemps"
Public Sub CreacioSegellTemps()
    
    'Utilitats
    Set Utils = New PSISClient.Utils
    
    'Tipus de signatura disponibles
    'TimeStamp amb signatura CMS/CAdes:   urn:ietf:rfc:3161
    'TimeStamp amb signatura XMLDsig:     oasis:names:tc:dss:1.0:core:schema:XMLTimeStampToken
    'TimeStamp amb signatura XAdES:       oasis:names:tc:dss:1.0:core:schema:XAdESTimeStampToken
    Dim signatureType As String
    signatureType = "oasis:names:tc:dss:1.0:core:schema:XMLTimeStampToken"
    
    'Inicialitzaci del client
    Dim proxy As New PSISClient.digitalSignatureService
    proxy.url = "http://psisbeta.catcert.net/psis/catcert-test/dss"
    
    'Creaci de l'element amb un document
    Dim method As New DigestMethodType
    method.Algorithm = "http://www.w3.org/2000/09/xmldsig#sha1"

    Dim document(1) As DocumentHash
    Set document(0) = New DocumentHash
    document(0).ID = "Doc1"
    document(0).digestMethod = method
    document(0).DigestValue = Utils.Base64File("c:/psis/timestamp-digest1.dat")

    'Creaci de l'element amb els documents a signar
    Dim documents As New InputDocuments
    documents.Items = document

    'Creaci de l'element amb un certificat
    Dim certificates(1)
    certificates(0) = Utils.Base64File("c:/psis/timestamp-certificate.dat")
    
    Dim types(1) As Long
    types(0) = ItemsChoiceType.ItemsChoiceType_X509Certificate
            
    Dim certData As New X509DataType
    certData.Items = certificates
    certData.ItemsElementName = types

    'Creaci de l'element opcional amb el certificat per fer el segell de temps
    Dim dataObject(1) As Object
    Set dataObject(0) = certData

    Dim types1(1) As Long
    types1(0) = ItemsChoiceType1.ItemsChoiceType1_X509Data

    Dim keyInfo As New KeyInfoType
    keyInfo.Items = dataObject
    keyInfo.ItemsElementName = types1

    Dim keySlt As New KeySelector
    Set keySlt.Item = keyInfo

    'Creaci de l'element amb el conjunt de parmetres opcionals a consultar
    Dim optObjects(2)
    Set optObjects(0) = keySlt
    optObjects(1) = signatureType
    optObjects(2) = iObject
    
    Dim types7(2) As Long
    types7(0) = ItemsChoiceType7.ItemsChoiceType7_KeySelector
    types7(1) = ItemsChoiceType7.ItemsChoiceType7_SignatureType

    Dim optInputs As New OptionalInputs
    optInputs.Items = optObjects
    optInputs.ItemsElementName = types7

    'Creaci del missatge DSS
    Dim request As New PSISClient.SignRequest
    Set request.InputDocuments = documents
    Set request.OptionalInputs = optInputs
    
    'Visualitzaci de la petici
    Debug.Print Utils.MessageToString(request)
    
    'Execuci del servei
    Dim response As PSISClient.SignResponse
    Set response = proxy.sign(request)
    
    'Visualitzaci de la resposta
    Debug.Print Utils.MessageToString(response)
    
End Sub


