using System;
using System.Web;
using net.catcert.psis;

public class ValidacioSignaturaCMS
{

    public ValidacioSignaturaCMS()
    {
    }

    static void Main()
    {

        // Utilitats
        Utils utils = new Utils();

        // Objectes temporals
        Object[] objects = null;
        ItemsChoiceType6[] types6 = null;

        // Inicialitzaci del client
        digitalSignatureService proxy = new digitalSignatureService();

        // Indicar ladrea del servidor
        proxy.Url = "http://psisbeta.catcert.net/psis/catcert-test/dss";


        // Composici del missatge

        // Dades de prova
        byte[] signature = utils.Base64File("C:/Documents and Settings/jriudavets/Mis documentos/Visual Studio 2005/Projects/TestPSIS/TestPSIS/bin/Release/cms-signature.dat");
        byte[] doc = utils.Base64File("C:/Documents and Settings/jriudavets/Mis documentos/Visual Studio 2005/Projects/TestPSIS/TestPSIS/bin/Release/cms-doc.dat");

        // Creaci de l'element amb la signatura CMS a verificar
        Base64Signature b64signature = new Base64Signature();
        b64signature.Type = "urn:ietf:rfc:3852";
        b64signature.Value = signature;

        SignatureObjectType signatureType = new SignatureObjectType();
        signatureType.Item = b64signature;

        // Creaci de l'element amb els documents a enviar
        Base64Data b64data = new Base64Data();
        b64data.Value = doc;

        DocumentType[] document = new DocumentType[1];
        document[0] = new DocumentType();
        document[0].Item = b64data;

        InputDocuments inpDocuments = new InputDocuments();
        inpDocuments.Items = document;

        // Creaci de l'element amb els parmetres opcionals a consultar
        OptionalInputs optInputs = new OptionalInputs();

        objects = new Object[1];
        objects[0] = new Object();

        types6 = new ItemsChoiceType6[1];
        types6[0] = ItemsChoiceType6.ReturnProcessingDetails;

        optInputs.Items = objects;
        optInputs.ItemsElementName = types6;

        // Creaci del missatge DSS
        VerifyRequest requestDocument = new VerifyRequest();
        requestDocument.SignatureObject = signatureType;
        requestDocument.InputDocuments = inpDocuments;
        requestDocument.OptionalInputs = optInputs;

        // Execuci del servei
        VerifyResponse responseDocument = proxy.verify(requestDocument);

        // Visualitzaci de la petici
        Console.WriteLine(utils.MessageToString(requestDocument));

        // Visualitzaci de la resposta
        Console.WriteLine(utils.MessageToString(responseDocument));

    }
}
