using System;
using System.Web;
using net.catcert.psis;
public class ValidacioSegellDeTemps
{
    public ValidacioSegellDeTemps()
    {
    }
    
    static void Main()
    {
        // Utilitats
        Utils utils = new Utils();
        // Objectes temporals
        Object[] objects=null;
        ItemsChoiceType6[] types6 = null;
        // Inicialitzaci del client
        digitalSignatureService proxy = new digitalSignatureService();
        // Indicar ladrea del servidor
        proxy.Url = "http://psisbeta.catcert.net/psis/catcert-test/dss";
        // Composici del missatge
        // Dades de prova
        System.Xml.XmlElement timestamp = utils.XMLFile("C:/Documents and Settings/jriudavets/Mis documentos/Visual Studio 2005/Projects/TestPSIS/TestPSIS/bin/Release/timestamp-xml.dat");
        byte[] digest = utils.Base64File("C:/Documents and Settings/jriudavets/Mis documentos/Visual Studio 2005/Projects/TestPSIS/TestPSIS/bin/Release/timestamp-digest1.dat");
        // Creaci de l'element amb un document
        DigestMethodType method = new DigestMethodType();
        method.Algorithm="http://www.w3.org/2000/09/xmldsig#sha1";
        DocumentHash document = new DocumentHash();
        document.ID = "Doc1";
        document.DigestMethod = method;
        document.DigestValue = digest;
        // Creaci de l'element amb els documents a verificar
        InputDocuments documents = new InputDocuments();
        documents.Items = new DocumentHash[1] {document};
        // Creaci de l'element amb el segell de temps
        SignatureObjectType signaturetype = new SignatureObjectType();
        signaturetype.Any=timestamp;
        // Creaci de l'element amb els parmetres opcionals a consultar
        OptionalInputs optInputs = new OptionalInputs();
        objects = new Object[1];
        objects[0] = new Object();
        types6 = new ItemsChoiceType6[1];
        types6[0] = ItemsChoiceType6.ReturnProcessingDetails;
        optInputs.Items = objects;
        optInputs.ItemsElementName = types6;
        // Creaci del missatge DSS
        VerifyRequest requestDocument = new VerifyRequest();
        requestDocument.SignatureObject = signaturetype;
        requestDocument.OptionalInputs = optInputs;
        requestDocument.InputDocuments = documents;
        // Execuci del servei per a verificar
        VerifyResponse responseDocument = proxy.verify (requestDocument);
        // Visualitzaci de la petici
        Console.WriteLine(utils.MessageToString(requestDocument));
        // Visualitzaci de la resposta
        Console.WriteLine(utils.MessageToString(responseDocument));
    }
}
