using System;

namespace test
{
	using net.catcert.psis;
	using System.Web;

	public class ValidacioCertificat
	{
		public ValidacioCertificat()
		{
		}

		static void Main()  
		{

			// Utilitats
			Utils utils = new Utils();

			// Dades de prova
			byte[] certificate = utils.Base64File("certificate.dat");

			// Inicialitzaci del client
			digitalSignatureService proxy = new digitalSignatureService();

			// Indicar ladrea del servidor
			proxy.Url = "http://psis.catcert.net/psis/catcert/dss";

			// Composici del missatge
			X509DataType x509DataType = new X509DataType();

			Object[] certificates = new Object[1];
			certificates[0] = certificate;

			ItemsChoiceType[] certificateType = new ItemsChoiceType[1];
			certificateType[0] = ItemsChoiceType.X509Certificate;

			x509DataType = new X509DataType();
			x509DataType.Items = certificates;
			x509DataType.ItemsElementName = certificateType;

			SignatureObjectTypeOther other = new SignatureObjectTypeOther();
			other.X509Data = x509DataType;

			SignatureObjectType signature = new SignatureObjectType();
			signature.Item = other;

			/*
			 * Peticio d'informacio del Certificat (X509CertificateInfo)
			 *	- GivenName
			 *	- Surname
			 *	- KeyOwnerNif
			 *	- SerialNumber
			 *	- IssuerCA
			 */
			OptionalInputs optInputs = new OptionalInputs();
			ItemsChoiceType6[] types6 = new ItemsChoiceType6[1];
			Object[] objects = new Object[1];

			optInputs.ItemsElementName = types6;
			optInputs.Items = objects;

			// Colleccio dels attributs a demanar
			string[] attributeDesignators = new string[]
			{
				// GivenName
				"urn:oasis:names:tc:dss:1.0:profiles:XSS:certificateAttributes:SubjectDistinguishedName:givenName",

				// Surname
				"urn:oasis:names:tc:dss:1.0:profiles:XSS:certificateAttributes:SubjectDistinguishedName:surname",

				// KeyOwnerNIF
				"urn:catcert:psis:certificateAttributes:KeyOwnerNIF",

				// SerialNumber
				"urn:oasis:names:tc:dss:1.0:profiles:XSS:certificateAttributes:SerialNumber",

				// IssuerCA
				"urn:catcert:psis:certificateAttributes:issuerCA",
			};

			AttributeDesignator[] ads = new AttributeDesignator[ attributeDesignators.Length ];
			types6[0] = ItemsChoiceType6.ReturnX509CertificateInfo;
			objects[0] = ads;

			for( int i = 0; i < attributeDesignators.Length; i++ )
			{
				string attributeDesignator = attributeDesignators[i];

				AttributeDesignator ad = new AttributeDesignator();
				ad.Name = attributeDesignator;

				ads[i] = ad;
			}

			// Creaci del missatge DSS
			VerifyRequest requestDocument = new VerifyRequest();

			requestDocument.SignatureObject = signature;
			requestDocument.OptionalInputs = optInputs;

			/*
			 * !!! ATENCIO !!!
			 *	Especificar el profile XSS 
			 */
			requestDocument.Profile = "urn:oasis:names:tc:dss:1.0:profiles:XSS";


			// Visualitzaci de la petici
			Console.WriteLine(utils.MessageToString(requestDocument));

			// Execuci del servei
			VerifyResponse responseDocument = proxy.verify (requestDocument);

			// Visualitzaci de la resposta
			Console.WriteLine(utils.MessageToString(responseDocument));


			foreach( object o in responseDocument.OptionalOutputs.Items )
			{
				if ( o.GetType() == typeof(X509CertificateInfo) ) 
				{
					X509CertificateInfo ci = (X509CertificateInfo)o;

					foreach( Attribute a in ci.Attribute )
					{
						Console.WriteLine("Valors de l'atribut {0}", a.Name );

						if ( a.AttributeValue != null )
						{
							/*
							 * !!! ATENCIO !!!
							 *		Els atributs poden ser multivaluats
							 */
							for( int i = 0; i < a.AttributeValue.Length; i++ )
							{
								Console.WriteLine( "\t[{0}] : {1}", i, a.AttributeValue[i] );
							}
						}

						Console.WriteLine("\t---");
					}
				}
			}
		}
	}
}
