using System;

namespace PSISClient
{
	using System.Net;
	using System.Security.Cryptography.X509Certificates;

	public class MyPolicy : ICertificatePolicy 
	{
		/* 
		const long CertVALIDITYPERIODNESTING = 0x800B0102L ; 
		const long CertROLE = 0x800B0103L ; 
		const long CertPATHLENCONST = 0x800B0104L ; 
		const long CertCRITICAL = 0x800B0105L ; 
		const long CertPURPOSE = 0x800B0106L ; 
		const long CertISSUERCHAINING = 0x800B0107L ; 
		const long CertMALFORMED = 0x800B0108L ; 
		const long CertCHAINING = 0x800B010AL ; 
		const long CertREVOKED = 0x800B010CL ; 
		const long CertUNTRUSTEDTESTROOT = 0x800B010DL ; 
		const long CertREVOCATION_FAILURE = 0x800B010EL ; 
		const long CertWRONG_USAGE = 0x800B0110L ; 
		const long CertUNTRUSTEDCA = 0x800B0112L ; 
		*/ 

		const long CertCN_NO_MATCH = 0x800B010FL ; 
		const long CertEXPIRED = 0x800B0101L ; 
		const long CertUNTRUSTEDROOT = 0x800B0109L ; 

		public bool CheckValidationResult(ServicePoint srvPoint, X509Certificate certificate, WebRequest request, int certificateProblem) 
		{ 
			// you can do your own certificate checking here 
			// you can get the error values from WinError.h, all the certificate errors start with Cert_ 

			// we just return true so any certificate will work with this sample 


			if ((certificateProblem==unchecked( (int)CertEXPIRED)) ) 
			{ 
				Console.WriteLine(" Cert is in invalid time"); 
				return true; 
			} 

			else if (certificateProblem== unchecked ((int)CertUNTRUSTEDROOT)) 
			{ 
				Console.WriteLine("The CA is not trusted"); 
				return true; 
			} 

			else if ( certificateProblem== unchecked ((int)CertUNTRUSTEDROOT)) 
			{ 
				Console.WriteLine("The certificate name is not match"); 
				return true; 
			} 
			else if (certificateProblem == 0) 
			{ 
				return true; 
			} 
			else 
			{ 
				Console.WriteLine("Server Certificate has other problem" ); 
				return false; 

			} 
		} 

	} 

}
