using System;

namespace PSISClient.test
{
	using CSConsole.net.catcert.psis;
	using System.Web;

	public class CreacioSegellDeTemps
	{
		public CreacioSegellDeTemps()
		{
		}

		static void Main() 
		{

			// Utilitats
			Utils utils = new Utils();

			// Objectes temporals
			Object[] objects=null;
			ItemsChoiceType[] types = null;
			ItemsChoiceType1[] types1 = null;
			ItemsChoiceType7[] types7 = null;
							
			// Dades de prova
			byte[] certificate = utils.Base64File("c:/psis/timestamp-certificate.dat");
			
			byte[] digest = utils.Base64File("c:/psis/timestamp-digest1.dat");

			// Tipus de signatura disponibles
			// TimeStamp amb signatura CMS/CAdes: 	urn:ietf:rfc:3161
			// TimeStamp amb signatura XMLDsig: 	oasis:names:tc:dss:1.0:core:schema:XMLTimeStampToken
			// TimeStamp amb signatura XAdES:		oasis:names:tc:dss:1.0:core:schema:XAdESTimeStampToken
			string signatureType = "oasis:names:tc:dss:1.0:core:schema:XMLTimeStampToken";

			// Inicialitzaci del client
			digitalSignatureService proxy = new digitalSignatureService("http://psisbeta.catcert.net/psis/catcert-test/dss");

			// Creaci de l'element amb un document
			DigestMethodType method = new DigestMethodType();
			method.Algorithm="http://www.w3.org/2000/09/xmldsig#sha1";

			DocumentHash document = new DocumentHash();
			document.ID = "Doc1";
			document.DigestMethod = method;
			document.DigestValue = digest;

			// Creaci de l'element amb els documents a signar
			InputDocuments documents = new InputDocuments();
			documents.Items = new DocumentHash[1] {document};

			// Creaci de l'element amb un certificat
			objects = new Object[1];
			objects[0] = certificate;
			
			types = new ItemsChoiceType[1];
			types[0] = ItemsChoiceType.X509Certificate;
			
			X509DataType x509DataType = new X509DataType();
			x509DataType.Items = objects;
			x509DataType.ItemsElementName = types;

			// Creaci de l'element opcional amb el certificat per fer el segell de temps
			// Contindr el certificat de TSA de CATCert en Base64
			objects = new Object[1];
			objects[0] = x509DataType;

			types1 = new ItemsChoiceType1[1];
			types1[0] = ItemsChoiceType1.X509Data;

			KeyInfoType keyInfo = new KeyInfoType();
			keyInfo.Items=objects;
			keyInfo.ItemsElementName = types1;

			KeySelector keySelector = new KeySelector();
			keySelector.Item=keyInfo;

			// Creaci de l'element opcional amb l'objecte 
			IncludeObject iObject = new IncludeObject();
			iObject.ObjId = "Doc1";
			iObject.WhichDocument = "Doc1";
			iObject.hasObjectTagsAndAttributesSet=false;
			iObject.createReference=true;

			// Creaci de l'element amb el conjunt de parmetres opcionals a consultar
			objects = new Object[3];
			objects[0] = keySelector;
			objects[1] = signatureType;
			objects[2] = iObject;

			types7 = new ItemsChoiceType7[3];
			types7[0] = ItemsChoiceType7.KeySelector;
			types7[1] = ItemsChoiceType7.SignatureType;
			types7[2] = ItemsChoiceType7.IncludeObject;

			OptionalInputs optInputs = new OptionalInputs();
			optInputs.Items=objects;
			optInputs.ItemsElementName=types7;

			// Creaci del missatge DSS
			SignRequest request = new SignRequest();
			request.OptionalInputs = optInputs;
			request.InputDocuments = documents;

			// Visualitzaci de la petici
			Console.WriteLine(utils.MessageToString(request));
			
			// Execuci del servei
			SignResponse response = proxy.sign (request);

			// visualitzaci de la resposta
			Console.WriteLine(utils.MessageToString(response));

		}
	}

}
